/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: David Papa <iamyou@umich.edu>

ChangeLog:
2004-09-15: ChangeLog started
*/

#include <iostream>
#include <fstream>
#include <string>

#include <qworkspace.h>

#include "tcl.h"

#include "oaDesignDB.h"

#include "mainwindow.h"
#include "Controller/controller.h"

using std::cerr;
using std::endl;
using std::ifstream;
using std::string;

int main(int argc, char *argv[])
{
    try
    {
        //MVC: Model
        oa::oaDesignInit();
        oa::oaLibDefList::openLibs();
        
        //MVC: Controller   
        oagBazaar::Controller controller;
     
        //MVC: View
        QApplication app(argc, argv);
        QWidget *mainWindowParent = 0;
        oagBazaar::MainWindow mainWin(mainWindowParent, "OAGear Bazaar", controller);
        app.setMainWidget(&mainWin);

        //register the view with the controller
        controller.setView(mainWin);
        
        mainWin.show();

        char *home_dir = getenv("HOME");
        string bazaarrc_file_name = string(home_dir) + string("/.bazaarrc");
        ifstream bazaarrc(bazaarrc_file_name.c_str());
        if(bazaarrc.good())
        {
          bazaarrc.close();
          string command = string("source ") + bazaarrc_file_name;
          controller.runCommand(command.c_str());
        }

        return app.exec();
    }
    catch (oa::oaException &excp) 
    {
        cerr << "Uncaught OA Exception, Error: " << excp.getMsg() << endl;    
        exit(1);
    }
}


