/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: David Papa <iamyou@umich.edu>

ChangeLog:
2004-09-15: ChangeLog started
 */

#include <cassert>
#include <ostream>
#include <fstream>
#include <iostream>

#include <qvariant.h>
#include <qtextedit.h>
#include <qlineedit.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qimage.h>
#include <qpixmap.h>

#include "dockingCommandWindow.h"
#include "DebugLog.h"

using std::ostream;
using std::streambuf;
using std::cout;
using std::endl;
using std::string;

namespace oagBazaar 
{

    /*
     *  Constructs a commandWindowT as a child of 'parent', with the
     *  name 'name' and widget flags set to 'f'.
     */
    commandWindowT::commandWindowT( QWidget* parent, Controller& controller, const char* name, WFlags fl )
        : QWidget( parent, name, fl ), _controller(controller)
        {
            if ( !name )
                setName( "commandWindowT" );

            resize(600,200);

            QBoxLayout *topLayout = new QVBoxLayout( this, 5 );

            logTextEdit = new QTextEdit( this , "logTextEdit" );
            logTextEdit->setTextFormat( Qt::LogText );
            logTextEdit->setReadOnly(true);

            topLayout->addWidget(logTextEdit);


            QBoxLayout *bottomBar = new QHBoxLayout( topLayout, 5 );

            commandLineEdit = new QLineEdit( this, "commandLineEdit" );
            bottomBar->addWidget(commandLineEdit);

            sendCommandButton = new QPushButton(this, "sendCommandButton");
            sendCommandButton->setText( tr( "Send Command" ) );
            sendCommandButton->setDefault(true);
            bottomBar->addWidget(sendCommandButton);

            connect( commandLineEdit, SIGNAL( returnPressed() ),
                    this, SLOT( execute() ) );

            connect( sendCommandButton, SIGNAL( pressed() ),
                    this,              SLOT( execute() )   );



            echo("Welcome to Bazaar");
            //echo("This window currently contains diagnostic information... \n");

            show();
        }


    /*
     *  Sets the strings of the subwidgets using the current
     *  language.
     */
    void commandWindowT::languageChange()
    {
        setCaption( tr( "Command Window" ) );
        QWhatsThis::add( this, tr( "Input TCL Commands to control Bazaar here" ) );
    }


    void commandWindowT::echo(const std::string& s)
    {
        log<<s<<endl;
        drawLog();
    }

    void commandWindowT::execute(void)
    {
        if(commandLineEdit->text() != "")
        {
            _controller.runCommand(std::string(commandLineEdit->text().ascii()));
            commandLineEdit->setText("");
            drawLog();
            emit serviceCommand();
        }
    }

    void commandWindowT::refresh(void)
    {
        drawLog();
    }

    QoaCommandDockWindow::QoaCommandDockWindow(QWidget* parent, Controller& controller):
        QDockWindow(QDockWindow::InDock,parent,"Bottom dock window"),
        _cwnd(0)
    {
        setSizePolicy( QSizePolicy::Maximum, QSizePolicy::Expanding);
        setNewLine(true);
        setOrientation(QDockWindow::Horizontal);
        setResizeEnabled(true);
        setVerticallyStretchable(false);   

        _cwnd = new commandWindowT(this, controller);

        //These two lines capture cout and cerr and redirect them into the dockingCommandWindow
        //comment them out to get rid of this behavior
        cerr.rdbuf(_cwnd->log_rdbuf());
        cout.rdbuf(_cwnd->log_rdbuf());


        _cwnd->setGeometry(0,0,600,200);
        setWidget(_cwnd);
        _cwnd->show();

        setGeometry(0,0,600,200);
    }

    void commandWindowT::echoDebugStream(void)
    {
        log << DebugLog::get()->log.str() << endl;
    }

    void commandWindowT::drawLog(void)
    { 
        QString msg(log.str().c_str());
        logTextEdit->setText(msg); 
        logTextEdit->ensureVisible(0, logTextEdit->contentsHeight()); 
    }

}


