/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: David Papa <iamyou@umich.edu>

ChangeLog:
2004-09-15: ChangeLog started
 */

/*! \file SchemInstViewWnd.h */

#ifndef _SCHEMATIC_INST_VIEW_SCROLLING_FRAME_
#define _SCHEMATIC_INST_VIEW_SCROLLING_FRAME_

#include <qscrollview.h>
#include <qwidget.h>
#include "SchemInstView.h"
#include "oaBase.h"
#include "oaDesignDB.h"

namespace oagBazaar
{

    namespace Qoag
    {
        ///A Qt QScrollView object that holds a QoaSchemInstView
        class QoaSCVScrollingFrame : public QScrollView
        {
            Q_OBJECT
            public:
                QoaSCVScrollingFrame(QWidget* w, const std::string& lib, const std::string& cell, const std::string& view);
                void contentsMouseMoveEvent(QMouseEvent * e);

            protected:
                void resizeEvent(QResizeEvent * e);

                QSize sizeHint(void);
                QSize minimumSizeHint(void);

            private: //functions
                QoaSchemInstView* createSchem(QWidget* w, oa::oaSimpleName inst_name,
                        const std::string& lib, const std::string& cell, const std::string& view);

            private: //data
                std::string _lib;
                std::string _cell;
                std::string _view;

                QoaSchemInstView* _schem;

        };

    }; //end namespace Qoag

}

#endif


