/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: David Papa <iamyou@umich.edu>

ChangeLog:
2004-09-15: ChangeLog started
 */

#include <iostream>
#include <string>

#include <assert.h>

#include "SchemInstViewWnd.h"
#include "DebugLog.h"

using std::string;
using std::cerr;
using std::endl;

using oa::oaModule;
using oa::oaModInst;
using oa::oaIter;
using oa::oaNativeNS;
using oa::oaSimpleName;

namespace oagBazaar
{

    namespace Qoag
    {

        QoaSCVScrollingFrame::QoaSCVScrollingFrame(QWidget* w, 
                const std::string& lib, const std::string& cell, const std::string& view):
            QScrollView(w,"Schematic View Frame"), _lib(lib), _cell(cell), _view(view)
        {
            oa::oaNativeNS cap_ns;
            oa::oaString cap_name;
            oagConnection dbConnection(_lib, _cell, _view);
            oagDesignBlock oagDBlk = dbConnection.getOAGDesignBlock();
            oagDBlk.design->getCellName(cap_ns, cap_name);
            setCaption((string("Schematic: ")+static_cast<const char*>(cap_name)).c_str() );


            setHScrollBarMode(QScrollView::AlwaysOn);
            setVScrollBarMode(QScrollView::AlwaysOn);
            //setCornerWidget(new QSizeGrip(this));

            oaNativeNS ns;
            //Take the first inst to start with
            oa::oaModule* oamod =  oagDBlk.design->getTopModule();
            assert(oamod && "Design must have a top module");
            oaIter<oaModInst> instIter(oamod->getInsts());
            oaModInst   *inst = instIter.getNext();
            if(!inst) 
            {
                DebugLog::ostream()<<"SCVWNDDEBUG: There are no insts!  Aborting..."<<endl;
                return;
            }
            oaSimpleName sn(ns,getNameFromOA(inst).c_str());
            _schem = createSchem(viewport(), sn, _lib, _cell, _view);
            addChild(_schem);

            setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Expanding);
            setResizePolicy(QScrollView::AutoOneFit);
            viewport()->setMouseTracking(true);

            resize(350, 350);
            resizeContents(350, 350);
            _schem->resizeGL(visibleWidth(), visibleHeight());
            _schem->show();

            //DebugLog::ostream()<<"SCVWNDDEBUG: Inside QSCVScrollingFrame constructor"<<endl;
            //DebugLog::ostream() << "DPDEBUG : viewport size: (" << viewport()->width() << "," << viewport()->height() << ")" << endl;
        }

        QoaSchemInstView* QoaSCVScrollingFrame::
            createSchem(QWidget* parent,oa::oaSimpleName inst_name, 
                    const std::string& lib, const std::string& cell, const std::string& view)
            {
                oagConnection dbConnection(lib, cell, view);
                oagDesignBlock oagDBlk = dbConnection.getOAGDesignBlock();
                oaModule* oamod = oagDBlk.design->getTopModule();
                oaModInst* inst = oaModInst::find(oamod, inst_name);
                assert(inst);
                Qoag::QoaSchemInstView* s = new Qoag::QoaSchemInstView(parent, _lib, _cell, _view, inst);
                return s;
            }

        void QoaSCVScrollingFrame::resizeEvent( QResizeEvent * e)
        {
            resize(e->size().width(), e->size().height());
            resizeContents(visibleWidth(), visibleHeight());
            viewport()->resize(visibleWidth(), visibleHeight());
            _schem->resizeGL(visibleWidth(), visibleHeight());
        }

        void QoaSCVScrollingFrame::contentsMouseMoveEvent( QMouseEvent * e )
        {
            //DebugLog::ostream()<<"SCVWNDDEBUG: Mouse moves coming in the frame"<<endl;
            e->accept();
            _schem->mouseOver( e->pos().x(), e->pos().y() );
        }

        QSize QoaSCVScrollingFrame::sizeHint(void)
        {
            return QSize(350, 350);
        }

        QSize QoaSCVScrollingFrame::minimumSizeHint(void)
        {
            return QSize(350, 350);
        }

    }; //end namespace Qoag

}


