/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: David Papa <iamyou@umich.edu>

ChangeLog:
2004-09-15: ChangeLog started
*/

/*! \file QoagCommon.h */

#ifndef _Q_OA_COMMON_
#define _Q_OA_COMMON_

#include <string>
#include <vector>

#include <qcolor.h>
#include <qgl.h>
#include <qaction.h>

#include "oaBase.h"

#include "QoagCommonTempl.h"

namespace oagBazaar
{


    /** \namespace oagBazaar::Qoag  
      \brief Namespace of Qt objects for OAGear 
      Qt objects that represent gui elements for entities in OpenAccess
     */
    namespace Qoag
    {
        typedef const int QoaTermGeomDirT;
        typedef double internalCoordT;
        typedef unsigned internalInstIndexT;
        typedef unsigned internalTermIndexT;
        typedef oa::oaPoint internalPointT;
        typedef int QoaInternalDirT;
        typedef std::pair< oa::oaModInstTerm* , oa::oaModInstTerm* > SchemEdgeT;

        extern const int QoaTermGeomLeft;
        extern const int QoaTermGeomRight;
        extern const int QoaTermGeomCenter;
        //TODO re-evaluate this design (QoaPinGeomDirT),
        //  its probably not perfect
        //  too busy to fix it right now


        extern const double _L_txt_margin;
        extern const double _R_txt_margin;
        extern const double _L_term_margin;
        extern const double _R_term_margin;
        extern const double _txt_ht;
        extern const QColor _inst_border_color;
        extern const QColor _inst_foreground_color;
        extern const QColor _selected_inst_border_color;
        extern const QColor _selected_inst_foreground_color;
        extern const double _border_size;
        extern const double _term_width;
        extern const QColor _term_border_color;
        extern const QColor _term_foreground_color;

        extern const int QoaSCVCenter;
        extern const int QoaSCVLeft;
        extern const int QoaSCVRight;
        extern const double _SCV_gl_coord_height;
        extern const double _SCV_gl_coord_width;
        extern const double _SCV_glFovy;
        extern const double _SCV_gl_near_clipping_z;
        extern const double _SCV_gl_far_clipping_z;


        ///sorting less than functor for SchemInstView class
        struct Cmp_std_pair_internalInstIndexT_internalInstIndexT
        {
            bool operator()(std::pair<internalInstIndexT,internalInstIndexT> a,
                    std::pair<internalInstIndexT,internalInstIndexT> b);
        };

        ///Do the math and use gl to draw two differently colored rectangles on top of eachother to make a bordered rect
        /**  
          \param glw A QGLWidget* to draw on 
          \param box An oaBox object representing the rectangle to draw
          \param frame_width Width of the frame as a portion of the whole width, e.g. 0.05 is 5%
          \param frame_height Height of the frame as a portion of the whole height, e.g. 0.05 is 5%
          \param border_color QColor for the color of the border
          \param foreground_color QColor for the color of the foreground 
         */
        void QoaGlFrameRectd(QGLWidget* glw, const oa::oaBox& box, 
                double frame_width, double frame_height, 
                QColor border_color, QColor foreground_color);


        ///Do the math and use gl to draw two differently colored rectangles on top of eachother to make a bordered rect
        /**  
          \overload
          \param glw A QGLWidget* to draw on 
          \param box An oaBox object representing the rectangle to draw
          \param frame_width Width of the frame as a portion of the whole width, e.g. 0.05 is 5%
          \param frame_height Height of the frame as a portion of the whole height, e.g. 0.05 is 5%
          \param border_color A triple of RGB values for the color of the border
          \param foreground_color A triple of RGB values for the color of the foreground 
         */
        void QoaGlFrameRectd(QGLWidget* glw, const oa::oaBox& box, 
                double frame_width, double frame_height, 
                const std::vector<double>& border_color, const std::vector<double>& foreground_color);



        ///Do the math and use gl to draw two differently colored rectangles on top of eachother to make a bordered rect
        /**  
          \overload
          This overload compiles a GL display list, without drawing it.
          \param _nName a GLuint specifying the GL display list to draw to
          \param box An oaBox object representing the rectangle to draw
          \param frame_width Width of the frame as a portion of the whole width, e.g. 0.05 is 5%
          \param frame_height Height of the frame as a portion of the whole height, e.g. 0.05 is 5%
          \param border_color A triple of RGB values for the color of the border
          \param foreground_color A triple of RGB values for the color of the foreground 
         */
        void QoaGlFrameRectd(GLuint _nName, const oa::oaBox& box, 
                double frame_width, double frame_height, 
                const std::vector<double>& border_color, const std::vector<double>& foreground_color);
        
        ///Do the use gl to draw a colored rectangle on a gl widget
        /**  
          \param glw A QGLWidget* to draw on 
          \param box An oaBox object representing the rectangle to draw
          \param border_color QColor for the color of the border
          \param foreground_color QColor for the color of the foreground 
         */
        void QoaGlRectd(QGLWidget* glw, const oa::oaBox& box, 
                 const std::vector<double>& foreground_color);

        ///verify that none of members of bb are DBL_MAX, else abort
        void _checkBoundsInit(const oa::oaBox& bb, const std::string& IDname);

        ///transform a point POld relative to BBoxOld, to return the new point relative to BBoxNew
        oa::oaPoint transformPoint(const oa::oaPoint& POld, const oa::oaBox& BBoxOld, const oa::oaBox& BBoxNew);

        ///Create a color vector given 3 doubles, for RGB colors 
        void setVectorColor(std::vector<double>& v, double, double, double);


        ///Get the bounding box for placement from the oaSnapBoundary
        oa::oaBox getPlacementBBox(const oa::oaInst * const inst);

        class QoagTCLAction : public QAction
        {
              Q_OBJECT
           public:
              QoagTCLAction( QObject* parent, const char* name = 0);
              QoagTCLAction( const QString& menuText, QKeySequence accel, QObject* parent, const char* name = 0);
              QoagTCLAction( const QString& text, const QIconSet& icon, const QString& menuText, QKeySequence accel, QObject* parent, const char * name = 0, bool toggle = false);
              QoagTCLAction( const QString& text, const QString& menuText, QKeySequence accel, QObject* parent, const char* name = 0, bool toggle = false);
              QoagTCLAction( QObject* parent, const char* name, bool toggle);

           private:
              void connectActivatedToExecute(void);

           signals:
              void execute( QAction* );

           private slots:
              void emitExecute( void );
        };

    }; //namespace Qoag

}

#endif


