/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */
/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you want to add, delete, or rename functions or slots, use
** Qt Designer to update this file, preserving your code.
**
** You should not define a constructor or destructor in this file.
** Instead, write your code in functions called init() and destroy().
** These will automatically be called by the form's constructor and
** destructor.
*****************************************************************************/


#include <vector>
#include <iostream>
#include <limits>

#include "qfiledialog.h"

#include "oaUtils.h"
#include "QoagCommon/QoagCommonTempl.h"

void netEquivalenceFormT::init()
{
    connect(libComboBox, SIGNAL(activated(const QString&)), this, SLOT(libChanged(const QString&)));
  connect(cellComboBox, SIGNAL(activated(const QString&)), this, SLOT(cellChanged(const QString&)));
    readLibs();
}

void netEquivalenceFormT::libChanged( const QString & libNameQ )
{
    cellComboBox->clear();
    
    //std::cout<<"Got lib changed"<<std::endl;
    std::string libName = libNameQ.ascii();
    oa::oaNativeNS ns;
    oa::oaScalarName libScalarName(ns, libName.c_str());
    oa::oaLib* lib = oa::oaLib::find(libScalarName);
    oa::oaBoolean haveAccess=false;
    if(lib)
    {
        haveAccess=lib->getAccess(oa::oacReadLibAccess);
    }
    else
    {
        std::cout<<"Warning: Couldnt find lib: \""<<libName<<"\""<<std::endl;
        cellComboBox->clear();
    }
    
    if(haveAccess)
    {
      
      std::vector<std::string> cellList = oagBazaar::getCellNamesInLib(lib);
      //std::cout<<"Found lib: \""<<libName<<"\" has "<<cellList.size()<<" cells."<<std::endl;
      //cellComboBox->clear();
      for(unsigned i = 0 ; i < cellList.size(); ++i)
        cellComboBox->insertItem(QString(cellList[i].c_str()));
      cellChanged(QString(cellList[0].c_str()));
      lib->releaseAccess();
    }
    else
    {
        std::cout<<"Warning: Couldnt get read access to lib: \""<<libName<<"\""<<std::endl;
        cellComboBox->clear();
     }
}

void netEquivalenceFormT::readLibs()
{
    //std::cout<<"Reading libs..."<<std::endl;
    std::vector<std::string> libList  = oagBazaar::walkLibDefList(oa::oaLibDefList::getTopList());
    libComboBox->clear();
    cellComboBox->clear();
    for(unsigned i = 0; i < libList.size(); ++i)
        libComboBox->insertItem(QString(libList[i].c_str()));
    
    if(!libList.empty())
    {
    //hack to make "designs" default if it exists
    int designsIdx = 0;
    for(unsigned i = 0; i < libList.size(); ++i)
        if(libList[i] == "designs")
        {
            assert( i < static_cast<unsigned>(std::numeric_limits<int>::max()) && "Overflow on lib list");
            designsIdx = static_cast<int>(i);
        }
    
    
    libComboBox->setCurrentItem(designsIdx);
    libChanged(QString(libList[designsIdx].c_str()));
    
    }
}



void netEquivalenceFormT::checkEQ()
{
        std::string checkEQCmd = "check_equivalence ";
    checkEQCmd += " -lib ";
    checkEQCmd += static_cast<const char*>(libComboBox->currentText());
    checkEQCmd += " -cell1 ";
    checkEQCmd += static_cast<const char*>(cellComboBox->currentText());
    checkEQCmd += " -net1 ";
    checkEQCmd += static_cast<const char*>(net1ComboBox->currentText());    
    checkEQCmd += " -net2 ";
    checkEQCmd += static_cast<const char*>(net2ComboBox->currentText());
    checkEQCmd += " -randomPattern ";
    checkEQCmd += static_cast<const char*>(cyclesEdit->text());
    checkEQCmd += " -liberty ";
    checkEQCmd += static_cast<const char*>(libertyEdit->text());
     emit checkPressed(checkEQCmd.c_str());
     close();
}

void netEquivalenceFormT::cellChanged( const QString & cellNameQ )
{
        net1ComboBox->clear();
        net2ComboBox->clear();
	
    //std::cout<<"Got cell changed"<<std::endl;
    std::string cellName = cellNameQ.ascii();
    oa::oaNativeNS ns;
    oa::oaScalarName cellScalarName(ns, cellName.c_str());
    QString libNameQ = libComboBox->currentText();
    std::string libName = libNameQ.ascii();
    oa::oaScalarName libScalarName(ns, libName.c_str());
    oa::oaLib* lib = oa::oaLib::find(libScalarName);
    oa::oaBoolean haveAccess=false;
    if(lib)
    {
        haveAccess=lib->getAccess(oa::oacReadLibAccess);
    }
    else
    {
        std::cout<<"Warning: Couldnt find lib: \""<<libName<<"\""<<std::endl;
        cellComboBox->clear();
    }
    
    if(haveAccess)
    {
             oa::oaCell* selectedCell = oa::oaCell::find(lib, cellScalarName);
             std::vector<std::string> viewList = oagBazaar::getCellViewNames(selectedCell);
             //std::cout<<"Found cell: \""<<cellName<<"\" has "<<viewList.size()<<" views."<<std::endl;
            int netlistIdx = 0;
            for(unsigned i = 0; i < viewList.size(); ++i)
            if(viewList[i] == "netlist")
              netlistIdx = i;
	    
	    try
	    {
		    oa::oaScalarName viewScalarName(ns, viewList[netlistIdx].c_str());
		oa::oaDesign* des = oa::oaDesign::open(libScalarName, cellScalarName, viewScalarName, 'r');
		oa::oaBlock* blk = des->getTopBlock();
	              oa::oaIter<oa::oaNet> netIter = blk->getNets();
		while(oa::oaNet* curNet = netIter.getNext())
		{
		    std::string netName = oagBazaar::Qoag::getNameFromOA(curNet);
		    net1ComboBox->insertItem(QString(netName.c_str()));
		    net2ComboBox->insertItem(QString(netName.c_str()));		   
		}
	    }
	    catch( oa::oaException& excp)
	    {
		std::cerr<<"Exception loading net names in netEquivalenceFormT: "<< excp.getMsg() << std::endl;
		exit(1);
	    }

             lib->releaseAccess();
    }
    else
    {
        std::cout<<"Warning: Couldnt get read access to lib: \""<<libName<<"\""<<std::endl;
        cellComboBox->clear();
   
    }   
}




void netEquivalenceFormT::selectLibertySlot()
{
    QFileDialog * fileDialog = new QFileDialog(this);
    fileDialog->setModal(true);
    fileDialog->exec();
    QString filename = fileDialog->selectedFile();
    libertyEdit->setText(filename);

    delete fileDialog;
}
