/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

#include "samplePlugIn.h"

#include "qcanvas.h"

int HelloWorldPlugInCmd(ClientData clientData,
            Tcl_Interp *interp,
            int argc,
            CONST char *argv[])
{
        //remove compiler unused warnings
        static_cast<void>(clientData);
        static_cast<void>(interp);
        static_cast<void>(argc);
        static_cast<void>(argv);

        cout<<"Hello from the PlugIn World!"<<endl;
        return TCL_OK;
}

int HelloWorldPlugInWindowCmd(ClientData clientData,
            Tcl_Interp *interp,
            int argc,
            CONST char *argv[])
{
        //remove compiler unused warnings
        static_cast<void>(clientData);
        static_cast<void>(interp);
        static_cast<void>(argc);
        static_cast<void>(argv);
   
   QCanvas* canvas = new QCanvas(100, 100);
   /*QCanvasView* canvasView = */new QCanvasView(canvas);

   QScrollView* helloView = new QScrollView();
   QLabel* helloWorldLabel = new QLabel(helloView);
   helloWorldLabel->setFont(QFont("Times", 48));
   helloWorldLabel->setText("Hello World!");
   helloWorldLabel->resize(400,100);
   helloView->resize(400, 100);
   helloView->setCaption("Sweeeeeeeet!");
   HelloWorldPlugIn* plugInPtr = static_cast<HelloWorldPlugIn*>(clientData);
   plugInPtr->getAPI()->giveWidget(helloView);
   return TCL_OK;
}

oagBazaar::oagBazaarPlugInInterface* newPlugIn(void)
{
  return new HelloWorldPlugIn();
}

void HelloWorldPlugIn::load(std::auto_ptr<oagBazaar::oagBazaarPlugInAPI> bazaarAPI)
{
   //DO THIS FIRST BEFORE ANYTHING ELSE 
   _bazaarAPI = bazaarAPI; //take ownership of the API object pointer

   _bazaarAPI->registerTCLCommand(&HelloWorldPlugInCmd, "hello_world_pi");
   _bazaarAPI->registerTCLCommand(&HelloWorldPlugInWindowCmd, "hello_world_window", this);

   QPopupMenu* helloWorldMenu = _bazaarAPI->addMenu("Hello World");
   QToolBar* helloWorldToolBar = _bazaarAPI->addToolBar("Hello World Bar");

   QAction* sayHWAction = _bazaarAPI->createAction("hello_world_pi", "Say It", "Say hello world", "cut.png");
   QAction* hWWindowAction = _bazaarAPI->createAction("hello_world_window", "Show It", "Draw hello world", "paste.png");

   _bazaarAPI->addMenuItem(helloWorldMenu, sayHWAction);
   _bazaarAPI->addToolBarButton(helloWorldToolBar, sayHWAction);

   _bazaarAPI->addMenuItem(helloWorldMenu, hWWindowAction);
   _bazaarAPI->addToolBarButton(helloWorldToolBar, hWWindowAction);

}
