/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: David Papa <iamyou@umich.edu>
 
ChangeLog:
2005-11-07: ChangeLog started
 */

#include <iostream>
#include <string>

#include "OAGearCommon.h"

using std::cout;
using std::cerr;
using std::endl;
using std::string;

using oa::oaScalarName;
using oa::oaString;
using oa::oaLibDefList;
using oa::oaLibDef;
using oa::oaType;
using oa::oaIter;
using oa::oaLibDefListMem;
using oa::oacLibDefType;
using oa::oacLibDefListRefType;
using oa::oaLibDefListRef;
using oa::oaChar;

namespace oagBazaar
{

  std::ostream& operator<<(std::ostream& os, const oa::oaBox& box)
  {
    os<<"( "<<box.left()  <<" , "
    <<box.bottom()<<" , "
    <<box.right() <<" , "
    <<box.top()   <<" )";
    return os;
  }

  void
  updateLibDefsFile(oaScalarName libraryName, oaString libraryPath)
  {
    // Save the new library definition in the session top library definition.
    // Since oaLibdefList::openLibs() opened in 'r'ead-only mode,
    // first call get() on top list to change its mode to 'a'ppend.
    oaLibDefList *list = oaLibDefList::getTopList();
    if (list)
    {
      oaString    topListPath;
      list->getPath(topListPath);
      list->get(topListPath,'a');
      oaLibDef::create(list, libraryName, libraryPath);
      list->save();
    }
  }

  //chompAfterLastSlash is used by getLibraryPath
  oaString chompAfterLastSlash(const oaString& str)
  {
     string s(static_cast<const oaChar*>(str));
     s = s.substr(0,s.find_last_of('/')) + '/';
     return oaString(s.c_str());
  }

  oaString getLibraryPath(oaLibDefList *list)
  {
    oaType memType;
    oaString libPath;
    oaLibDefList *nextList = 0;
    oaIter<oaLibDefListMem> listIter(list->getMembers());
    while (oaLibDefListMem *listMem = listIter.getNext())
    {
      switch (memType = listMem->getType())
      {
      case oacLibDefType :
        ((oaLibDef *)(listMem))->getLibPath(libPath);
        cerr << "Got Lib Def at Path = "<< libPath << endl;
        libPath = chompAfterLastSlash(libPath);
        cerr << "Chomped it and got Path = "<< libPath << endl;
        //process lib def ...
        return libPath;
        break;

      case oacLibDefListRefType :
        ((oaLibDefListRef *)(listMem))->getRefListPath(libPath);
        nextList = oaLibDefList::get(libPath,'r');
        return getLibraryPath(nextList);
        break;

      default:
            return oaString("");
            break;

      }
    }
    return oaString("");
  }


}



