/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: David Papa <iamyou@umich.edu>

ChangeLog:
2004-09-15: ChangeLog started
*/

/*! \file LayoutViewWnd.h */

#ifndef LAYOUT_VIEW_WND_H
#define LAYOUT_VIEW_WND_H

#include <qwidgetfactory.h>
#include <qscrollview.h>
#include <qapplication.h>
#include <qmenubar.h>
#include <qpopupmenu.h>
#include <qpushbutton.h>
#include <qpainter.h>
#include <qpixmap.h>
#include <qmessagebox.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qmultilineedit.h>
#include <qsizegrip.h>
#include <stdlib.h>
#include <string>
#include <iostream>
#include "oaDesignDB.h"
#include "oaBase.h"
#include "LayoutInstView.h"
#include "oagConnect.h"
#include <vector>

namespace oagBazaar 
{

    ///The Qt QFrame object that contains a glLayoutWidget
    class LayoutViewWnd : public QFrame
    {
        Q_OBJECT 
        public:
            LayoutViewWnd(QWidget* parent, oagConnection* dbConnection);

            void zoom_in(void);
            void zoom_out(void);

            const std::string& get_lib(void) { return _lib; }
            const std::string& get_cell(void) { return _cell; }
            const std::string& get_view(void) { return _view; }

            QScrollBar*  horizontalScrollBar(void);
            QScrollBar*  verticalScrollBar(void);
            QWidget*  cornerWidget(void) { return 0; }

            void resizeEvent( QResizeEvent* event );

        public slots:
            void showCells(void);
            void hideCells(void);
            void showPins(void);
            void hidePins(void);
            void showNets(void);
            void hideNets(void);
            void showLabel(const std::string& label_str);
            void hideLabel(void);
            void initDesign(void);
            void readOA(void);
            void refresh(void);
            void setModified(void);
            void setUnmodified(void);

            void updateScrollBars(); 

            

        private: //functions
            void normalize_point(int& x, int& y);
            void normalize_distance(int& x, int& y);
            void apply_zoom(void);
            //removed for now, so that the default resize behavior is used
            //void resizeSelfAndContents(int width, int height);
            void createLayout(void);
            QSize viewportSize(void);
            void setcaption(void);


        private: //data
            bool _drawCells;
            bool _drawPins; 
            bool _drawNets;
            bool _drawPlacing;
            bool _isModified;

            double _zoom_factor;

            oa::oaBox _CoreRegionBBox;
            glLayoutWidget* _layout;
            QLabel* _placingLabel;
            QScrollBar *_horiz, *_vert;

            std::string _lib;
            std::string _cell;
            std::string _view;

            oagConnection* _dbConnection;
    };


}


#endif

