/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: David Papa <iamyou@umich.edu>

ChangeLog:
2004-09-15: ChangeLog started
*/

#include <iostream>
#include <qscrollview.h>
#include "LayoutInstView.h"
#include "oagConnect.h"
#include "../QoagCommon/QoagCommon.h"
#include "DebugLog.h"

using std::cout;
using std::cerr;
using std::endl;

using oagBazaar::Qoag::setVectorColor;
using oagBazaar::Qoag::QoaGlFrameRectd;
using oagBazaar::Qoag::QoaGlRectd;

namespace oagBazaar 
{

    const double lmargin = 0.05; //5%
    const double rmargin = 0.05; //5%
    const double tmargin = 0.05; //5%
    const double bmargin = 0.05; //5%

    glLayoutWidget::glLayoutWidget(QWidget* parent, const oa::oaBox& coreRegion)
        :QGLWidget(parent,"cellWidget"), _coreRegion(coreRegion),_zoom(0.0), _scrollHorizPct(50), _scrollVertPct(50)
        {
            setFormat(QGLFormat(DoubleBuffer|DepthBuffer));
            initializeGL();
            resizeCR(coreRegion);

            setZoom(_zoom); //calls resizeGL(_zoom);
        }

    void glLayoutWidget::initializeGL()
    {
        qglClearColor(white);
        glShadeModel(GL_FLAT);
        DebugLog::ostream()<<"Initializing gl"<<endl;
    }

    void glLayoutWidget::resizeCR(const oa::oaBox& coreRegion)
    {
        _coreRegion = coreRegion;
    }

    void glLayoutWidget::resizeGL(double zoom)
    {
        _zoom = zoom;
        //int w = static_cast<int>(_coreRegion.getWidth()*_zoom)+1, 
        //    h = static_cast<int>(_coreRegion.getHeight()*_zoom)+1;
        //DebugLog::ostream()<<"Resizing Gl "<<_coreRegion.getWidth()*_zoom<<","<<_coreRegion.getHeight()*_zoom<<" zoom:"<<_zoom<<endl;

        ////set the size of this widget, and the glViewport
        ////to be the same size
        //int newSizeX = static_cast<int>(w * (1.0 + lmargin + rmargin)),
        //    newSizeY = static_cast<int>(h * (1.0 + bmargin + tmargin));
        //resize(newSizeX, newSizeY);

        //glViewport(_coreRegion.getWidth()*-lmargin, _coreRegion.getWidth()*(1.0 + rmargin), _coreRegion.getHeight()*-bmargin, _coreRegion.getHeight()*(1.0+tmargin));
        //glViewport(-size().width()/2.0, -size().height()/2.0, size().width()/2.0, size().height()/2.0);
        //glViewport(-size().width(), -size().height(), size().width(), size().height());
        glViewport(0, 0, size().width(), size().height());

        //GLdouble x = _coreRegion.getWidth() * (1 + rmargin + lmargin) / 2.0  , 
        //            y  = _coreRegion.getHeight()* (1 + bmargin + tmargin) / 2.0, 
                   //centerz = 0;

        glMatrixMode(GL_PROJECTION);
        glLoadIdentity();
        //GLfloat x = (GLfloat) width / height;
        //glFrustum(-x,x,-1.0,1.0,5.0,15.0); 
        //glEnable(GL_DEPTH_TEST);
        //glEnable(GL_CULL_FACE);
        //glOrtho(0, cw, 0, ch, 1.0, -1.0); 
        //glOrtho(0/2.0, width/2.0, 0/2.0, height/2.0, 1.0, -1.0); 



        glOrtho(_coreRegion.getWidth()*-lmargin, _coreRegion.getWidth()*(1.0 + rmargin), 
                _coreRegion.getHeight()*-bmargin, _coreRegion.getHeight()*(1.0+tmargin), 
                1.0, -2.0); 
        glTranslated((_coreRegion.getWidth()/2.0), (_coreRegion.getHeight()/2.0), 0);
       
        //glFrustum(_coreRegion.getWidth()*-lmargin, _coreRegion.getWidth()*(1.0 + rmargin), 
        //          _coreRegion.getHeight()*-bmargin, _coreRegion.getHeight()*(1.0+tmargin), 
        //          1.0f, 10000.0f); 

        //gluPerspective( 3.0, x/y, 0.0, 10000.0);

        glMatrixMode(GL_MODELVIEW);
        glLoadIdentity();

        //GLdouble eyez = 1.0 / _zoom;
        //cout<<"DPDEBUG  zoom: "<<_zoom<<endl;
        //gluLookAt(x, y, eyez, x, y, centerz, 0.0f, 1.0f, 0.0f);
        //if(eyez > 9998.0) eyez = 9998.0;
        //glTranslated(x, y, 0);
        //glTranslated(0, 0, -eyez - 1.00);
        glTranslated(0, 0,  - 1.00);
        glTranslated(-(_coreRegion.getWidth()/2.0)*pow(2.0, _zoom), -(_coreRegion.getHeight()/2.0)*pow(2.0, _zoom), 0);
        //glTranslated(-(_coreRegion.getWidth()/2.0/_zoom), -(_coreRegion.getHeight()/2.0/_zoom), 0);
        //double sum=0.0;
        //if(_zoom < 0)
        //{
        //for(double z = -1.0; z >= _zoom; z-=1.0)
        //   sum+=pow(2.0, z-1.0);
        //    cout<<"DPDEBUG: sum: "<<sum<<" _coreRegion.getWidth(): "<<_coreRegion.getWidth()<<" product: "<<sum*_coreRegion.getWidth()<<endl;
        // glTranslated(sum*_coreRegion.getWidth(), sum*_coreRegion.getHeight(), 0);
        //}
        //else
        //for(double z = 1.0; z <= _zoom; z+=1.0)
        //{
        //   sum+=pow(2.0, z-2.0);
        //    cout<<"DPDEBUG: sum: "<<sum<<" _coreRegion.getWidth(): "<<_coreRegion.getWidth()<<" product: "<<sum*_coreRegion.getWidth()<<endl;
        // glTranslated(-sum*_coreRegion.getWidth(), -sum*_coreRegion.getHeight(), 0);
        //}
       
        //cout<<"DPDEBUG: _scrollHorizPct: "<<_scrollHorizPct<<" _scrollVertPct "<<_scrollVertPct<<endl;
        //cout<<"DPDEBUG: translate x: "<< -(_coreRegion.getWidth()*pow(2.0, _zoom)*(_scrollHorizPct-50.0) / 100.0)<<" translate y "<< _coreRegion.getHeight()*pow(2.0, _zoom)*(_scrollVertPct-50.0) / 100.0<<endl;
        //glTranslated(-(_coreRegion.getWidth()*(_scrollHorizPct-50.0) / 100.0), _coreRegion.getHeight()*(_scrollVertPct-50.0) / 100.0, 0.);
        glTranslated(-(_coreRegion.getWidth()*pow(2.0, _zoom)*(_scrollHorizPct-50.0) / 100.0), _coreRegion.getHeight()*pow(2.0, _zoom)*(_scrollVertPct-50.0) / 100.0, 0.);
        glScaled(pow(2.0,_zoom), pow(2.0, _zoom), 0);
        updateGL();
    }

    void glLayoutWidget::paintGL()
    {
        glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
        draw();
        //draw_test_pattern();
    }

    void glLayoutWidget::draw_test_pattern()
    {
        qglColor(green);
        glRectd(0,0,100,100);
    }

    void glLayoutWidget::draw()
    {
        if(_coreRegion == oa::oaBox(oa::oaCoord(INT_MAX), oa::oaCoord(INT_MAX), oa::oaCoord(-INT_MAX), oa::oaCoord(-INT_MAX)))  
            return;

        glPushMatrix();
        //glLoadIdentity();
        //glTranslated(0, 0, -1.0);
        qglColor(green);
        glBegin(GL_LINE_STRIP);
        glVertex2d(_coreRegion.left() , _coreRegion.bottom());
        glVertex2d(_coreRegion.left() , _coreRegion.top());
        glVertex2d(_coreRegion.right(), _coreRegion.top());
        glVertex2d(_coreRegion.right(), _coreRegion.bottom());
        glVertex2d(_coreRegion.left() , _coreRegion.bottom());
        glEnd();

        //std::vector<double> inst_border_color;
        //setVectorColor(inst_border_color, 0.0, 0.25, 0.7); //<---- same blue
        //std::vector<double> inst_foreground_color;
        //setVectorColor(inst_foreground_color, 0.5, 0.0, 0.0); //<--- darker red

        std::vector<double> inst_border_color;
        setVectorColor(inst_border_color, 0.0, 0.25, 0.7); //<---- same blue
        std::vector<double> inst_foreground_color;
        setVectorColor(inst_foreground_color, 0.75, 0.75, 1.0); //<--- gold


        for(std::vector<oa::oaBox>::const_iterator it = _insts.begin();
                it != _insts.end();
                ++it)
        {
            if(_insts.size() > 100) //turn off borders over 1000 insts
                QoaGlRectd(this, (*it), inst_foreground_color); 
            else
                QoaGlFrameRectd(this, (*it), 
                        Qoag::_border_size * static_cast<double>(it->getHeight())/it->getWidth(), 
                        Qoag::_border_size,
                        inst_border_color, inst_foreground_color);
        }
        //DebugLog::ostream()<<"Size: "<<_insts.size()<<endl;
        glPopMatrix();
    }

    void glLayoutWidget::addInst(const oa::oaBox& new_cell)
    {
        _insts.push_back(new_cell);
    }

    void glLayoutWidget::setZoom(double zoom)
    { 
        _zoom = zoom; 
        resizeGL(_zoom); 
        //updateGL();
    }

    void glLayoutWidget::scrollHorizValue(int val)
    {
       _scrollHorizPct = val;
        resizeGL(_zoom); 
    }

    void glLayoutWidget::scrollVertValue(int val)
    {
       _scrollVertPct = val;
        resizeGL(_zoom); 
    }

}


