/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: Aaron P. Hurst <ahurst@eecs.berkeley.edu>
 
ChangeLog:
2005-05-31: ChangeLog started
*/

#if !defined(oagAiNode_P)
#define oagAiNode_P

#include <map>
#include <string>
#include <list>
#include "oagAiRef.h"

#define NUM_WORDS_AINODE_USER_DATA 2

using namespace std;

namespace oagFunc {
    class Manager;
};

namespace oagAi {

// *****************************************************************************
// PersistentNode
//
/// \brief The persistent data of an and/inverter node.
//
// *****************************************************************************

class PersistentNode {
  friend class Graph;
  
  public:
    
    // *****************************************************************************
    // SequentialData
    //
    /// \brief Annotated information about sequential behavior.
    //
    // *****************************************************************************

    struct SequentialData {
        typedef enum {BLACK_BOX,
                      PRIMITIVE,
                      FEEDBACK}         AbstractionLevel;
        AbstractionLevel                abstractionLevel;

        /// Valid only for BLACK_BOX abstraction level:
        map<string, Ref>              signals;
        /// Valid only for PRIMITIVE abstraction level:
        Ref                           gate;       
        // feedback 
        
        SequentialData(AbstractionLevel a) { abstractionLevel = a; }
    };
    
    // an ai node can be one of several types
    typedef enum{NONE, 
                 AND, 
                 TERMINAL, 
                 CONSTANT0, 
                 SEQUENTIAL}    Type;
  
    void    serialize(void* buf);
    int     unserialize(void* buf);
    int     getSerializedSize();

  protected:
  
    Type                        type;

    // the core data (dependent upon the type)
    union{
        Ref                   left;
        Ref                   terminal_driver;
        Ref                   nextState;
    };
    union{
        Ref                   right;
        SequentialData       *sequentialData;
    };

    Ref               equivalent;
    
    PersistentNode();
    ~PersistentNode();

};


// *****************************************************************************
// Node
//
/// \brief An and/inverter node.
//
// *****************************************************************************

class Node : public PersistentNode {
  friend class Graph;
    
  public:
  
    typedef Node::SequentialData SequentialData;
    typedef Node::Type Type;

    Ref             next;

    unsigned int    traversalID;

    // the following field is for application use
    unsigned int    data[NUM_WORDS_AINODE_USER_DATA];
    
  protected:

    Ref             self;

    list<Ref>       fanout;
    unsigned int    fanoutCount;
    
    unsigned int    refCount;

    // constructors
                    Node();                    // NONE node constructor
                    Node(Ref driver);          // TERMINAL node constr.
                    Node(Ref left, Ref right); // AND node constructor
                    
    void            clear();
                    
  protected:
    
    void           *external_terminal_connection;

};

}

#endif
