
/* (c) Copyright 2004-2006, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: Aaron P. Hurst <ahurst@eecs.berkeley.edu>
 
ChangeLog:
2006-12-28: ChangeLog started
*/

// THIS FILE MAY BY INCLUDED MULTIPLE TIMES

#include <iostream>

#define QUIT_ON_ERROR { \
    assert(false);      \
    exit(0); }
#define QUIT_ON_INTERNAL_ERROR {             \
    assert(false);                           \
    cerr << "ERROR: Internal error" << endl; \
    exit(0); }

#if defined(DEBUG_PRINT)
#undef DEBUG_PRINT
#undef DEBUG_PRINTLN
#undef DEBUG_PRINTMORE
#endif

#if !defined(DEBUG_SYMBOL)
// default debugging symbol
#define DEBUG_SYMBOL '-'
#endif

#if defined(DEBUG)
#define DEBUG_PRINT( x )     { cout << DEBUG_SYMBOL << " " << x; }
#define DEBUG_PRINTLN( x )   { cout << DEBUG_SYMBOL << " " << x << endl; }
#define DEBUG_PRINTMORE( x ) { cout << x; }
#else
#define DEBUG_PRINT( x )
#define DEBUG_PRINTLN( x )
#define DEBUG_PRINTMORE( x )
#endif
