/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: Philip Chong <pchong@cadence.com>

ChangeLog:
2005-07-22: ChangeLog started
*/

#if !defined(oagUtilOption_P)
#define oagUtilOption_P

#include <string>
#include <assert.h>

namespace oagUtil {

/// \brief A class representing a single command line option.
///
/// This class is used by oagUtil::OptionParser to represent a
/// single command line option.  Users can use the query functions
/// isGiven() and getValue() to obtain the results from the
/// command line parsing.

class Option {

    friend class OptionParser;
    friend class OptionUnitTest;
    friend class OptionParserUnitTest;

    private:
        // Private constructor prevents users from creating this class
        Option(const char *name,
               const char *helpString,
               bool isMandatory,
               const char *argName = 0) :
            _name(name),
            _helpString(helpString),
            _isMandatory(isMandatory),
            _argName(argName)
        {
            assert(name);
            assert(helpString);
        };

        // Private destructor prevents users from destroying this class
        ~Option()
        {
            // nothing
        }

    public:
        /// Check if the option was encountered in the command
        /// line which was parsed.
        ///
        /// \return True if the option was encountered.
        bool isGiven() {
            return !_argValue.empty();
        }

        /// Gets the string argument for the option from the 
        /// command line which was parsed.
        ///
        /// \return String argument from the parsed command line, or NULL
        ///         if the option was not specified on the command line
        ///         or does not take an argument.
        const char *getValue () {
            return _argValue.empty() ? 0 : _argValue.c_str();
        }

    private:
        const char  *_name;
        const char  *_helpString;
        bool        _isMandatory;
        const char  *_argName;
        std::string _argValue;
};

}

#endif
