/************************************************************
* 
* File: oagTimerTimerUtil.h
* Author: Santiago Mok (smok@ee.ucla.edu)
* Created: 09-22-2010
* Last Modified: Wed 22 Sep 2010 12:30:22 PM PDT
*
************************************************************/
#if !defined(oagTimerTimerUtil_P)
#define oagTimerTimerUtil_P 

#include <string>
#include <vector>
#include <iostream>
#include <iomanip>
#include <map>
#include "oaDesignDB.h"
#include "oagTimerModel.h"
#include "oagTimerTimer.h"
#include "oagTimerTPointMaster.h"

namespace oagTimer{
/*---------------------------------------------------------*/
using namespace oa;
using namespace std;
/*---------------------------------------------------------*/
class TimerUtil{
  /*! Variables */
  private:
    Timer *timer;

/*---------------------------------------------------------*/
  /*! Functions */
  public:
    /*! Constructor and Desctructor*/
    TimerUtil();
    ~TimerUtil();
    void add(Timer *t);
/*---------------------------------------------------------*/
/*! CELL DELAY RELATED FUNCTIONS */
    /*! This function queries the worst (R/F) delay (from input
     * to output) with respect to the given input pin. 
     * @PARAM t: the current timer object
     * @PARAM inPin: the input from delay propagates
     * @RETURN cell delay 
     */
     DelayType getCellDelay(oaOccInstTerm *inPin, oaOccInstTerm *outPin);
/*---------------------------------------------------------*/
};

//TimerUtil timerUtil;
/*---------------------------------------------------------*/
} //namespace
#endif
