/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: Zhong Xiu <zxiu@andrew.cmu.edu>

ChangeLog:
2004-09-15: ChangeLog started
2005-08-05: Moved to separate file
*/

#if !defined(oagTimerTermObserver_P)
#define oagTimerTermObserver_P

#include "oaDesignDB.h"

namespace oagTimer {

/*! \brief Incremental timing callback class.

    This class is derived from the oaObserver class. 
    The purpose of this class is to catch changes to the netlist and
    invalidate any TimingPoints which are affected.
*/
class TermObserver : public oa::oaObserver<oa::oaOccTerm>
{
  public:
    /*! Constructor.

        \param priority Priority level for callback ordering.
        \param enabled True if the callback should be enabled.
    */
    TermObserver(oa::oaUInt4    priority,
                 oa::oaBoolean  enabled = true);

    /*! Callback after a term is created.

        \param term The newly created term.
    */
    void onPostCreate(oa::oaOccTerm *instTerm);

    /*! Callback before a term is modified.

        \param term The modified term.
        \param modType The modification type.
    */
    void onPreModify(oa::oaOccTerm          *term,
                     oa::oaTermModTypeEnum  modType);

    /*! Callback after a term is modified.

        \param term The modified term.
        \param modType The modification type.
    */
    void onPostModify(oa::oaOccTerm         *term,
                      oa::oaTermModTypeEnum modType);

    /*! Callback before a term is destroyed.

        \param term The term to be destroyed.
    */
    void onPreDestroy(oa::oaOccTerm *term);

  private:
    void invalidate(oa::oaOccTerm *term);
};

}

#endif
