/************************************************************
* 
* File: oagTimerSubTimer.h
* Author: Santiago Mok (smok@ee.ucla.edu)
* Created: 03-11-2011
* Last Modified: Thu 24 Mar 2011 01:58:38 PM PDT
*
************************************************************/
#if !defined(oagTimerSubTimer_H)
#define oagTimerSubTimer_H

#include "oaDesignDB.h"
#include "oagTimerTimer.h"

#include <map>
#include <vector>

namespace oagTimer {
    using namespace std;
    using namespace oa;
/*---------------------------------------------------------*/
class SubTPoint{
  public:
    SubTPoint();
    ~SubTPoint();
    double getArr();
    double getReq();
    double getSlew();
    double getSlack();
    double getRiseSlack();
    double getFallSlack();
    
  public:
    double delay;
    double riseArr;
    double fallArr;
    double riseReq;
    double fallReq;
    double riseSlew;
    double fallSlew;
};
/*---------------------------------------------------------*/
class SubTimer{
  public:
    SubTimer(oaDesign *des, Timer *t, oaOccInst *i, oaString c);
    ~SubTimer();

    void setLoad(double l);
    double getCellDelayEstimate(oaOccInstTerm *i);
    double getDeltaDelay();
    double getDeltaSlack();
    double getWorstSlack();

  private:
    SubTPoint getSubTP(oaOccInstTerm *i);
    void buildTimingGraph();
    double getDeltaArr(oaOccInstTerm *it);
    double getMinDeltaSlack(oaOccInst *i);
    double getDeltaSlack(oaOccInstTerm *it);
    void getOtherInsts(oaOccInstTerm *i);

    void updateArr();
    double getCapLoad(oaOccInstTerm *i, oaString otherSize);
    void computeArr(oaOccInstTerm *inpTerm, oaString cellMaster, double load);
    void getOtherArr(oaOccInstTerm *instTerm);

    void updateReq();
    void computeReq(oaOccInstTerm *inpTerm, oaString cellMaster, double load);
    void getOtherReq(oaOccInstTerm *instTerm, SubTPoint &subTP);

    //void computeNetDelay(oaOccInstTerm *i);

    //DEBUG
    void printAll();
    void print(oaOccInstTerm *i);
  private:
    oaDesign *design;
    Timer *timer;
    //current cell data
    oaOccInst *occInst;
    oaString masterCell;
    double currLoad;
    bool loadGiven;

    map<oaOccInstTerm*,SubTPoint> tpMap;
    vector<oaOccInst*> faninVec;
    vector<oaOccInst*> fanoutVec;
};
/*---------------------------------------------------------*/
}//namespace
#endif
