/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: Zhong Xiu <zxiu@andrew.cmu.edu>

ChangeLog:
2004-09-15: ChangeLog started
*/

#if !defined(oagTimerReport_P)
#define oagTimerReport_P

#include "oagTimerTimer.h"

namespace oagTimer {

class Report {
  public:
    Report(oaDesign *design, Timer *timer);
    ~Report();

    void pathReport(nodesSlopeDir & path);
    void reportAll();
    void reportEndpointsSlacks();
    void print(int w, const double d);

    void printNets();
    void printNets(netsSlacks & nNets);

  private:
    oaOccurrence *_occ;
    Timer *_timer;
};

}

#endif
