/************************************************************
* oagTimerPowerSenseOpt.h
* Gate sizing algorithm based on power sensitivity
* with incremental timing analysis
* by: Santiago Mok <smok@ee.ucla.edu>
* advised by: Prof. Puneet Gupta
* Electrical Engr Dept, UCLA
*
************************************************************/

#if !defined(oagTimerPowerSenseOpt_P)
#define oagTimerPowerSenseOpt_P

#include "string.h"
#include <vector>
#include "oaDesignDB.h"
#include "oagTimerSensitivity.h"
#include "oagTimerTimer.h"
#include "oagTimerUtil.h"


namespace oagTimer {

/*---------------------------------------------------------*/

using namespace oa;
using namespace std;
/*---------------------------------------------------------*/
bool compare_psense (SenseData a, SenseData b){
    if(a.delta < b.delta)
	return true;
    else
	return false;
}
/*---------------------------------------------------------*/
class PowerSenseOpt {
    public:
	PowerSenseOpt();
	~PowerSenseOpt();

    public:
	void Opt(oaDesign* des, Timer *t, duetType type);

    private:
	sensitivityList createSwapList(oaDesign *des, bool decrease_only);
	void reverseSwap(SenseData s);
	void printCurrList(sensitivityList list);
    private:
	oaDesign *design;
	Timer *timing;
	Util *u;
};
/*---------------------------------------------------------*/
} //namespace
#endif
