/************************************************************
* 
* File: oagTimerPeepHole.h
* Author: Santiago Mok (smok@ee.ucla.edu)
* Created: 01-24-2010
* Last Modified: Thu 23 Sep 2010 11:34:38 AM PDT
*
************************************************************/
#if !defined(oagTimerPeepHole_P)
#define oagTimerPeepHole_P

#include <vector>
#include <map>
#include <algorithm>
#include <iostream>

#include "oaDesignDB.h"
#include "oagTimerSensitivity.h"
#include "oagTimerUtil.h"
#include "oagTimerModel.h"
#include "oagTimerTimer.h"
#include "oagTimerCellData.h"
#include "oagTimerDesignTool.h"

namespace oagTimer{
/*---------------------------------------------------------*/
using namespace oa;
using namespace std;
/*---------------------------------------------------------*/
typedef map<oaModInst*,double> BoundingMap;
typedef map<oaOccInstTerm*,double> InstTermMap;
/*---------------------------------------------------------*/
struct swapData{
    oaModInst* inst;
    float currentLeakageSum;
    float prospectiveLeakageSum;
};
/*---------------------------------------------------------*/
typedef vector<swapData> swapVector;
typedef vector<CellType> CellVector;

class PeepHole {
  /*! Variables */
  /*private: 
    CellType *root;
    CellVector fanouts;
    double totalLeakagePower;
    double sizeability;
    int fanoutLevel;
    */
  public:
    //PeepHole();
    PeepHole(oaDesign *d,Timer* t, int lvl);
    ~PeepHole();

    /*CellType getRoot();
    CellVector getFanouts();
    double getLeakagePower();
    double getSizeability();
  private:
    void setLeakagePower();
    bool isFeasible();
    bool create(CellType *r, int lvl);
    */
    bool isPowerImprove();
    void reverseAllSizing();
    bool bestConfigExist();
    double minNetLeakage;
    void saveBestConfig();
    void reloadBestSizing();
    
    /* Set the current PeepHole object with 
     * the given root node (and fanout nodes)
     * and set the evaluation fanout timing
     * @return - 0: no error
     *	         1: not a valid peephole 
     *	      (reason: root already mark as fanout, viceversa, etc);
     */
    int set(oaModInst* i);
    int set(oaModInst* i, instVector f);

    /*! This function add a timing feasible and
     * downsized fanout instance to the feasibleSwaps vector
     * @PARAM CellData: the feasible fanout cell
     * @PARAM float: leakage power of the cell master before swap
     * @RETURN void
     */
    void setFeasibleFanout(CellData *cell, float prevLeakage);

    /*! This function search for all the possible fanout swaps 
     * that satisfy net leakage power decrease and reverse those that do not
     * @PARAM float: the root cell previous leakage power
     * @RETURN bool: true - if a candidate peephole was found
     *		     false - otherwise
     */
    bool commitFeasibleCandidates(float prevRootLeakage);

    oaModInst* getRoot();
    instVector getFanouts();
    float getLeakage();

    void update();

    void print();
  private:
    void initCellData();

    void clear();
    //Debug
    void printList(oaString s,vector<oaString> list);
  private:
    oaDesign *design;
    Timer* timing;

    /*! The root of this peephole */
    oaModInst* root;
    /*! A vector of fanout instances that are part of this peephole*/
    instVector fanouts;
    /*! Total leakage for this peephole*/
    double leakage_sum;
    float subNetLeakage;
    float feasibleNetLeakage;

    /*! A vector of feasible swap */
    swapVector feasibleSwaps;
    
    /*! Current lib master map*/
    map<oaModInst*,oaString> existingLibMasterMap;
    map<oaModInst*,oaString> minLeakageConfig;

    /*! Flag to indicate current peephole status*/
    bool empty;
    bool valid;
    int foLvl;
    vector<oaModInst*> currModInsts;
};//class
/*---------------------------------------------------------*/
}//namespace
#endif
