/************************************************************
* 
* File: oagTimerOptMinDelay.h
* Author: Santiago Mok (smok@ee.ucla.edu)
* Created: 01-26-2011
* Last Modified: Mon 14 Feb 2011 01:34:16 PM PST
*
************************************************************/
#if !defined(oagTimerOptMinDelay_P)
#define oagTimerOptMinDelay_P

#include "oaDesignDB.h"
#include "oagTimerTimer.h"
#include "oagTimerUtil.h"

#include <map>
#include <vector>
namespace oagTimer{
/*---------------------------------------------------------*/
class OptMinDelay{
  public:
    OptMinDelay(oaDesign *d, Timer *t);
    ~OptMinDelay();
    void run();

  private: 
    double getDelaySum();
    vector<int> getIndices(oaModInst *inst);
    void updateLM();
    void reverseLM();
    void saveCurrSizing();
    void reverseSizing();
    void save();
    void reload();

    //Debug:
    void test1();
    void test2();
    void printLMAssignment();
    double globalLM;

  private:
    oaDesign *design;
    Timer *timing;
    map<oaModInst*,oaString> currSizing;
    map<oaModInst*,oaString> bestDesign;

    int _N; // # of LM;
    double tau, alpha1, alpha2;
    Util ut;
    vector<oaModInst*> G; 
    
};
/*---------------------------------------------------------*/
}//namespace
#endif
