/************************************************************
* 
* File: oagTimerLR.h
* Author: Santiago Mok (smok@ee.ucla.edu)
* Created: 01-26-2011
* Last Modified: Mon 14 Mar 2011 08:20:58 PM PDT
*
************************************************************/
#if !defined(oagTimerLR_P)
#define oagTimerLR_P

#include "oaDesignDB.h"
#include "oagTimerTimer.h"
#include "oagTimerUtil.h"

#include <map>
#include <vector>
namespace oagTimer{
/*---------------------------------------------------------*/
class LR{
  public:
    LR(oaDesign *d, Timer *t);
    ~LR();

    void runDebug();
    void printAll(oaOccInst *inst);
    void printTiming(oaOccInst *inst);

    void runDP(int type);
    //void run();

  private: 
    double getDelaySum();
    vector<int> getIndices(oaModInst *inst);
    void setLMIndex();
    void projectLM();
    void updateLM();
    double getMaxInArr(oaOccInst *inst);
    void reverseLM();
    void saveSizing(map<oaModInst*,oaString> &m);
    void reloadSizing(map<oaModInst*,oaString> &m);

    void runAssign();

    double getLRObjective();
    void runDPAssign();
    void DpRelaxation();
    void mergeFanoutSolutions(oaOccInstTerm *outTerm);
    void pruneSolutions(vector<lrData> &d);
    void copyVecData(vector<lrData> &src, vector<lrData> &dst);
    void DpRestoration();
    double getFanoutsMinObjSum(oaOccInstTerm *i, oaString currSize);
    oaString getSolution(CellData *c);
    double getMaxWeightedFaninObj(oaOccInstTerm *out, oaOccInstTerm *other, oaString otherSize);
    oaString resolveInconsistency(CellData *c);

    /*! This function is used only in DP to query the max arrival time
     * to the given input arc (in) from the fanin instance
     * based on the given cellsize of the 
     * input arc's instance
     * @param oaOccInstTerm*: instance input arc
     * @param oaString: prospective size of the instance;
     */
    double getMaxArr(oaOccInstTerm *in, oaString prospSize);

    //Debug:
    void printLMAssignment();
    void printLMValues();
    void checkLMValues();
    void printMap(map<oaOccInstTerm*,oaString> m);
    void printDPGraph();
    double checkSum(oaModInst *inst);
    double globalLM;

  private:
    oaDesign *design;
    Timer *timing;
    double factor; //powerFactor;
    bool tolSet;
    bool iterRefine;

    int _N; // # of LM;
    double tau, alpha1, alpha2;
    Util ut;
    vector<oaModInst*> G; 

    map<oaOccInst*, oaString> dpSolutions;
};
/*---------------------------------------------------------*/
}//namespace
#endif
