#ifndef lpSizer__H
#define lpSizer__H

#include <stdio.h>
#include <string.h>
#include <utility>
#include <map>
#include <vector>
#include <string>
#include <iostream>
#include <time.h>
#include "oaDesignDB.h"

#include "oagTimerCellData.h"
#include "oagTimerDesignTool.h"
#include "oagTimerTimer.h"
#include "oagTimerUtil.h"
#include "oagTimerTimerUtil.h"

#include "solverIF.h"
//#include "lp_lib.h"

//#define ROBUST_SIZING

using namespace std;
using namespace oa;
using namespace solver; 
using namespace oagTimer;
//using namespace modeling;

/* Constants */

//namespace tg {
namespace oagTimer {

   /* tokens of p /d tradeoff */
    class sensToken {
      public:
      double DT; // Change in the delay 
      double DP; // Change in the power
      int size;
      oaString name;
      //int vth;
      //void fillData(** oaInst?);
    };
    
    class sensInfo {
    public:
      oaOccInst *inst;
      int size;
      vector<sensToken> data; //corresponding size
      void sort();
      double getSens(double);
      void modelSens(oaDesign *d, Timer *t,CellData *cell);
      double DTmin, DTmax;
      int DTminInd;
      //double wInSlack;
      oaString origSize;
      void assign(oaDesign *d, Timer* t, double);
      //int getInd(oaDesign *d, Timer* t, double);
    };
    
    class lpSA {
      private:
        int _N;
	oaDesign *topDesign;
	Timer *timer;
        vector<sensInfo> _sensInfo;
        vector <double> _allocSlack;
	solverIF s;
        //lprec * _lp;
	double *_lp;
	Util ut;
	map<oaModInst*,oaString> bestDesign;
	map<oaModInst*,oaString> currSizing;
      public:
        lpSA(oaDesign *des, Timer *t);
        
	static bool checkSlack;
	void run();
        void save();
        void reload();
        int iSA();
        int rSA();
        void checkAssign();
        void assign();
        void makeSensInfo();
	int getDriverIndex(oaOccInstTerm *i);
	void saveCurrSizing();
	void reloadSizing();
	void updateToken();
//	//void checkSlack();
        double Tc;
        double tcPeriod;
	void printCurrConfig();
	vector<oaModInst*> topDsgn;
    };
};

#endif
