/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: Philip Chong <pchong@cadence.com>

ChangeLog:
2005-06-27: ChangeLog started
*/

#include "oagUtilOptions.h"
#include <assert.h>

namespace oagUtil {

Options::Options(void)
{
}

Options::~Options()
{
}

void
Options::add(const char *name,
             bool       takesArgument,
             bool       isMandatory)
{
    ParseData p;
    p.takesArgument = takesArgument;
    p.isMandatory = isMandatory;
    p.given = false;
    registry[name] = p;
}

bool
Options::parse(const char *commandLine)
{
    static_cast<void>(commandLine);
    clearParseData();
    assert(0 && "Not implemented yet");
    return checkMandatory();
}

bool
Options::parse(int          argc,
               const char   *argv[])
{
    clearParseData();
    for (int i = 1; i < argc; ++i) {
        if(*argv[i] != '-') {
            return false;
        }
        const char *t = argv[i] + 1;
        OptionMap::iterator p(registry.find(t));
        if (p == registry.end()) {
            return false;
        }
        (p->second).given = true;
        if ((p->second).takesArgument) {
            ++i;
            if (i >= argc) {
                return false;
            }
            (p->second).argument = argv[i];
        }
    }
    return checkMandatory();
}

bool
Options::isGiven(const char *name)
{
    OptionMap::iterator p(registry.find(name));
    if (p == registry.end()) {
        return false;
    }
    return ((p->second).given);
}

const char *
Options::getValue(const char *name)
{
    OptionMap::iterator p(registry.find(name));
    if (p == registry.end()) {
        return 0;
    }
    if (!(p->second).given) {
        return 0;
    }
    if (!(p->second).takesArgument) {
        return 0;
    }
    return (p->second).argument.c_str();
}

void
Options::clearParseData(void)
{
    for (OptionMap::iterator i = registry.begin(); i != registry.end(); ++i) {
        (i->second).given = false;
    }
}

bool
Options::checkMandatory(void)
{
    for (OptionMap::iterator i = registry.begin(); i != registry.end(); ++i) {
        if ((i->second).isMandatory && !(i->second).given) {
            return false;
        }
    }
    return true;
}

}
