/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: Philip Chong <pchong@cadence.com>

ChangeLog:
2005-08-17: ChangeLog started
*/

#include "oagUtilGlobMatchUnitTest.h"
#include "oagUtilGlobMatch.h"

namespace oagUtil {

int GlobMatchUnitTest::runAllTests(void) {
    // match() tests
    GlobMatch m1("aaabbb");
    logOneTest(m1.match("aaabbb"), "match 1.1");
    logOneTest(!m1.match("aabbb"), "match 1.2");
    logOneTest(!m1.match("aaabb"), "match 1.3");
    logOneTest(!m1.match("bbbbbb"), "match 1.4");

    GlobMatch m2("a*bbb");
    logOneTest(m2.match("aaabbb"), "match 1.5");
    logOneTest(m2.match("aabbb"), "match 1.6");
    logOneTest(!m2.match("aaabb"), "match 1.7");
    logOneTest(!m2.match("bbbbbb"), "match 1.8");
    logOneTest(m2.match("abbb"), "match 1.9");
    logOneTest(m2.match("abbbbbb"), "match 1.10");

    GlobMatch m3("a?bbb");
    logOneTest(m3.match("aabbb"), "match 1.11");
    logOneTest(!m3.match("abbb"), "match 1.12");
    logOneTest(!m3.match("aaabb"), "match 1.13");
    logOneTest(!m3.match("bbbbb"), "match 1.14");
    logOneTest(m3.match("abbbb"), "match 1.15");

    GlobMatch m4("a*b*");
    logOneTest(m4.match("aabbb"), "match 1.16");
    logOneTest(m4.match("abbb"), "match 1.17");
    logOneTest(m4.match("aaabb"), "match 1.18");
    logOneTest(!m4.match("bbbbb"), "match 1.19");
    logOneTest(m4.match("abbbb"), "match 1.20");
    logOneTest(m4.match("ab"), "match 1.21");

    return getReturnCode();
}

}
