#ifndef solverIF__H
#define solverIF__H

#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <iostream>
#include <string>
#include <vector>
#include <queue>
#include <map>

#include "lp_lib.h"
#include "mosek.h"

#define SIF_MOSEK 1
#define SIF_LPSOLVE 2

#define PRINT_LP 0

#define BD_LE 1
#define BD_GE 2
#define BD_EQ 3

#define MAX_SOLVER_VAL 1e11

using namespace std;

namespace solver {

  class solverIF {
  public:
    ~solverIF(){
	deleteSolver();
    }
    /* Solver interface */
    static int solverType;
    void deleteSolver();
    void initializeSolver(int);
    void setBound(int, double, double);
    void setFree(int);
    void setObjective(int, double *, int *); 
    void addConstraint(int, double *, int *, int, double);
    void setLowerBound(int, double);
    void setUpperBound(int, double);
    void addQuadObjective(int, double *, int *, int *);
    void addQuadObjectiveEntry(double, int, int);
    int solveLP(double * xx);
    int solveQP(double * xx);
    void copySolution();
      
    //#ifdef LPSOLV      
    lprec * _lp;
    //#endif
      
    //#ifdef MOSEKSOLV      
    static MSKenv_t env;
    static MSKtask_t task;
    MSKrescodee r;
    //#endif
      
    int _nConstrs;
    int _nVars;
  };

};

#endif
