/************************************************************
* 
* File: oagTimerTimerUtil.cpp
* Author: Santiago Mok (smok@ee.ucla.edu)
* Created: 09-22-2010
* Last Modified: Wed 22 Sep 2010 12:43:12 PM PDT
*
************************************************************/
#include "oagTimerTimerUtil.h"

namespace oagTimer{
/*---------------------------------------------------------*/
using namespace oa;
using namespace std;
/*---------------------------------------------------------*/
TimerUtil::TimerUtil(){}
TimerUtil::~TimerUtil(){}
void
TimerUtil::add(Timer *t){
    timer = t;
}
/*---------------------------------------------------------*/
DelayType
TimerUtil::getCellDelay(oaOccInstTerm *inPin, oaOccInstTerm *outPin){
    TPoint *p = TPoint::get(outPin);
    assert(p);
    oaModTerm *masterTerm = outPin->getModInstTerm()->getTerm();
    assert(masterTerm);
    TPointMaster *tm = TPointMaster::get(masterTerm);
    assert(tm);
    oaOccInst *inst = outPin->getInst();
    assert(inst);
    DelayType delay = 0.0;
    TPointMaster::pathVector::iterator i;
    for (i = tm->inPaths.begin(); i != tm->inPaths.end(); ++i) {
        assert(i->other);
        oaOccInstTerm *other = timer->getOccFromMod(inst, i->other);
        if (!other) continue;
	if (other != inPin) continue;
        TPoint *otherTP = TPoint::get(other); 
	for (unsigned int j = 0; j < otherTP->multiClockData.size(); ++j) { 
	    timingData *td = otherTP->multiClockData[j];
	    DelayType d = 0.0;
	    DelayType sl1 = td->riseSlew;
	    DelayType sl2 = td->fallSlew;
	    if (i->transition & TPointMaster::TRANSITION_SRC_RISE) {
		d = i->delay->lookup(p->load, sl1, tm->loadLimit);
		/*std::cout << " **SrcRise sl1:" << sl1 << " load:" << p->load
		    << " loadLimit" << tm->loadLimit << std::endl;*/
	    } 
	    else if (i->transition & TPointMaster::TRANSITION_SRC_FALL)
	    {
		d = i->delay->lookup(p->load, sl2, tm->loadLimit);
		/*std::cout << " **SrcFall sl2:" << sl2 << " load:" << p->load
		    << " loadLimit" << tm->loadLimit << std::endl;*/
	    }
	    if(d > delay) delay = d;
	}
    }
    std::cout << "Delay from:" << timer->getBlockName(inPin) 
	<< " to" << timer->getBlockName(outPin) << ":" << delay << std::endl;
    return delay; 
}
/*---------------------------------------------------------*/
} //namespace
