/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: Zhong Xiu <zxiu@andrew.cmu.edu>

ChangeLog:
2004-09-15: ChangeLog started
*/

#if !defined(oagTimerSdcData_P)
#define oagTimerSdcData_P

#include <map>
#include <set>
#include <vector>
#include <string.h>
#include <string>
#include "oaDesignDB.h"

namespace oagTimer {

/*!
  This structure provides the operation to alphabetically sort the strings.
*/
struct stringIsLess {
  bool operator()(const std::string a, const std::string b)  const {
    return a.compare(b) < 0;
  }
};


/*! a map of strings and double values */
typedef std::map<std::string, double, stringIsLess> delayMap;

/*! a map of two strings */
typedef std::map<std::string, std::string, stringIsLess> cellMap;

/* afshin-begin */


struct clock {
    double period;
    std::string name;
};

struct propagatedClock {
    clock *clk;
    int m;
    bool phase;
};

typedef std::map<std::string, int, stringIsLess> termIntMap;
/* afshin-end */


/*! This class collects the necessary constraints from the .sdc file. */
class SdcData {
  public:
    /*! The constructor, initiate all the members. */
    SdcData() {
      allInputs = allOutputs = false;
      allLoads = allCells = false;
      clockPeriod = allInputsDelay = allOutputsDelay = 0.0;
      propagatedClocks.clear();
      allFanoutLoads = 0.0;
      currentPort = "";
      allDrivingCells = "";
    }
    /*! The destructor, clear the data. */
    ~SdcData() {
      clear();
    }

    /*! This function cleans the data. */
    void clear();

    int pushAllInputs();
    int pushAllOutputs();
    int pushPorts(const char *s);
    int pushClockPorts(const char *s);
    int pushMultiCyclePath(std::string pathType, int m);
    int pushClock(double c, const char *s);
    int pushInputDelay(double d);
    int pushInputDelay(double d, std::string s);
    int pushOutputDelay(double d);
    int pushOutputDelay(double d, std::string s);

    int pushAllCells();
    int pushAllLoads();
    int pushDrivingCell(const char *s);
    int pushFanoutLoad(double d);

    /*! the clock period of the current design */
    double clockPeriod;
    /*! indicates if all inputs have the same delay values */
    bool allInputs;
    /*! the delay value of all PIs */
    double allInputsDelay;
    int allInputsClock;
    /*! indicates if all outputs have the same delay values */
    bool allOutputs;
    /*! the delay value of all POs */
    double allOutputsDelay;
    int allOutputsClock;

    /*! indicates if all outputs have the same loads */
    bool allLoads;
    /*! the fanout load of all POs */
    double allFanoutLoads;
    /*! indicates if all inputs have the same driving cells */
    bool allCells;
    /*! the driving cell of all PIs */
    std::string allDrivingCells;

/* afshin-begin */
    termIntMap termClock;
    termIntMap isClock;
    std::vector<propagatedClock*> propagatedClocks;
    termIntMap multiCycleConstraints;
    std::vector<std::string> ports;
    //clockPorts.reserve(numClockTP);
/* afshin-end */

    /*! the delay map table of PIs */
    delayMap extInputDelays;
    /*! the delay map table of POs */
    delayMap extOutputDelays;
    /*! the fanout load map table of POs */
    delayMap fanoutLoads;
    /*! the driving cell map table of PIs */
    cellMap drivingCells;
    /*! the current port's name */
    std::string currentPort;
};

}

#endif
