/************************************************************
* 
* File: oagTimerPeepHole.cpp
* Author: Santiago Mok (smok@ee.ucla.edu)
* Created: 01-24-2010
* Last Modified: Fri 24 Sep 2010 10:45:36 AM PDT
*
************************************************************/

#include "oagTimerPeepHole.h"

//#define DEBUG
namespace oagTimer{
/*---------------------------------------------------------*/
using namespace oa;
using namespace std;
/*---------------------------------------------------------*/
//Constructor
PeepHole::PeepHole(oaDesign *d,Timer* t, int lvl){
    design = d;
    timing = t;
    foLvl = lvl;    
    clear();
}
//Destructor
PeepHole::~PeepHole(){
    clear();
}
/*---------------------------------------------------------*/
/*PeepHole::PeepHole(){
    totalLeakagePower = 0;
    sizeability = 0;
    fanoutLevel = 0;
    fnouts.clear();
}
CellType
PeepHole::getRoot(){
    return root;
}
CellVector
PeepHole::getFanouts(){
    return fnouts;
}
double
PeepHole::getLeakagePower(){
    return totalLeakagePower;
}
double
PeepHole::getSizeability(){
    return sizeability;
}
void
PeepHole::setLeakagePower(){
    totalLeakagePower = root->master->leakage_power;
    for(int i=0; i<fnouts.size(); ++i){
	totalLeakagePower += (fnouts[i])->master->leakage_power;
    }
}
bool
PeepHole::isFeasible(){
    oaString maxSize = root->getMaxSize();
    if(maxSize.empty()) return false;
}
bool 
PeepHole::create(CellType *r, int lvl){
    assert(r);
    root = r;
    fanoutLevel = lvl;
    vector<oaModInst*> fo;
    fo.clear();
    DesignTool::getFanouts(root->inst, fo, fanoutLevel);
    if(fo.empty()) return false;
    for(int i=0; i<fo.size(); ++i){
	CellType *f = CellType::get(fo[i]);
	assert(f);
	fnouts.push_back(f);
    }
    setLeakagePower();
    return (isFeasible());
}*/
/*---------------------------------------------------------*/
oaModInst*
PeepHole::getRoot(){
    return root;
}
/*---------------------------------------------------------*/
instVector
PeepHole::getFanouts(){
    return fanouts;
}
/*---------------------------------------------------------*/
float
PeepHole::getLeakage(){
    return leakage_sum;
}
/*---------------------------------------------------------*/
void
PeepHole::update(){
    if(empty) return;
    //initCellData();
    //updateEvalFanouts();
}
/*---------------------------------------------------------*/
int
PeepHole::set(oaModInst *i){
#if defined(DEBUG)
    std::cout << "setCurrPeepHole(" << Util::getInstName(i) << ")" << std::endl;
#endif
    if(!empty) clear();
    assert(i);
    root = i;
    initCellData();
    if(!valid) return 1;
    empty = false;
    return 0;
}
/*---------------------------------------------------------*/
int
PeepHole::set(oaModInst *i, instVector f){
#if defined(DEBUG)
    std::cout << "setCurrPeepHole-Mult(" << Util::getInstName(i) << ")" << std::endl;
#endif
    if(!empty) clear();
    root = i;
    fanouts = f;
    initCellData();
    if(!valid) return 1;
    empty = false;
    return 0;
}
/*---------------------------------------------------------*/
void
PeepHole::initCellData(){
#if defined(DEBUG)
    std::cout << "initCellData()" << std::endl;
#endif
    sizingSignal head_Sig,fanout_Sig;	
    if((int)fanouts.empty()) head_Sig = DOWN_SIZE;
    else{
	head_Sig = UP_SIZE;
	fanout_Sig = DOWN_SIZE;
    }
    leakage_sum = 0;
    subNetLeakage = 0;
    feasibleNetLeakage = 0;
    // Initialize Root
    CellData *cell = CellData::get(root);
    assert(cell);
    cell->initSizing(head_Sig);
    //cell->setRootNode();
    existingLibMasterMap[root] = cell->master->name;
    leakage_sum += cell->master->leakage_power;

    // Initialize Fanouts
    for(instVector::iterator it=fanouts.begin();
	    it!=fanouts.end(); ++it){
	CellData *foCell = CellData::get(*it);
	assert(foCell);
	foCell->initSizing(fanout_Sig);
	//foCell->setFanoutNode();
	existingLibMasterMap[*it] = foCell->master->name;
	leakage_sum += foCell->master->leakage_power;
    }
    minNetLeakage = leakage_sum;
    valid = true;
}
/*---------------------------------------------------------*/
void
PeepHole::setFeasibleFanout(CellData *cell,float prevLeakage){
    swapData sd;
    sd.inst = cell->inst;
    float otherLeakage = prevLeakage;
    float propLeakage = cell->master->leakage_power;
    for(swapVector::iterator it=feasibleSwaps.begin();
	    it!=feasibleSwaps.end(); ++it){
	otherLeakage += it->currentLeakageSum;
	propLeakage += it->prospectiveLeakageSum;
    }
    sd.currentLeakageSum = otherLeakage;
    sd.prospectiveLeakageSum = propLeakage;
    feasibleSwaps.push_back(sd);
}
/*---------------------------------------------------------*/
bool
PeepHole::commitFeasibleCandidates(float prevRootLeakage){
    Util util;
    swapVector::reverse_iterator rev_it=feasibleSwaps.rbegin();
    CellData *rootCell = CellData::get(root);
    float prospRootLeakage = rootCell->master->leakage_power;
    float prospNetLeakage = rev_it->prospectiveLeakageSum+prospRootLeakage;
    float currentNetLeakage = rev_it->currentLeakageSum+prevRootLeakage;
    subNetLeakage = currentNetLeakage;
    feasibleNetLeakage = prospNetLeakage;
    if(prospNetLeakage < currentNetLeakage){
	/*for(instVector::iterator it=fanouts.begin();
		it!=fanouts.end(); ++it){
	    CellData *foCell = CellData::get(rev_it->inst);
	    assert(foCell);
	    foCell->isMark = true;
	}*/
	return true;
    }
    
    map<oaModInst*,oaString>::iterator it;
    for(swapVector::iterator svit=feasibleSwaps.begin();
	    svit!=feasibleSwaps.end(); ++svit){
	//Reverse Swap
	it = existingLibMasterMap.find(svit->inst);
	if(it!=existingLibMasterMap.end()){
	    CellData *foCell = CellData::get(svit->inst);
	    assert(foCell);
	    foCell->swap(it->second);
	    foCell->commitSwap();
	    foCell->isMark = false;
	    util.invalidateFanIOTiming(design,timing,foCell->inst);
	}
    }
    it = existingLibMasterMap.find(root);
    if(it!=existingLibMasterMap.end()){
	CellData *rootCell = CellData::get(root);
	assert(rootCell);
	rootCell->swap(it->second);
	rootCell->commitSwap();
	rootCell->isMark = false;
	util.invalidateFanIOTiming(design,timing,rootCell->inst);
    }
    return false;
}
/*---------------------------------------------------------*/
bool
PeepHole::isPowerImprove(){
    //cout << "Checking Net Leakage Improvement ..." << endl;
    CellData *roCell = CellData::get(root);
    assert(roCell);
    //std::cout << " root:" << roCell->master->leakage_power << endl;
    double newLeakagePower = roCell->master->leakage_power;
    for(instVector::iterator it=fanouts.begin();
	    it!=fanouts.end(); ++it){
	CellData *foCell = CellData::get(*it);
	assert(foCell);
	//std::cout << " inst:" << foCell->master->leakage_power << endl;
	newLeakagePower += foCell->master->leakage_power;
    }
    //std::cout << " New Leakage Power:" << newLeakagePower
	//<< " Old Leak Power:" << leakage_sum << std::endl;
    if(newLeakagePower < leakage_sum){ 
	if(newLeakagePower < minNetLeakage){
	    minNetLeakage = newLeakagePower;
	    saveBestConfig();
	}
	return true;
    }
    return false;
}
/*---------------------------------------------------------*/
void
PeepHole::saveBestConfig(){
    //std::cout << "Saving best config...." << endl;
    if(!minLeakageConfig.empty()) minLeakageConfig.clear();
    CellData *cell = CellData::get(root);
    assert(cell);
    minLeakageConfig[root] = cell->master->name;
    for(instVector::iterator it=fanouts.begin();
	    it!=fanouts.end(); ++it){
	CellData *foCell = CellData::get(*it);
	assert(foCell);
	minLeakageConfig[*it] = foCell->master->name;
    }
}
/*---------------------------------------------------------*/
bool 
PeepHole::bestConfigExist(){
    //cout << " minLeakSize:" << minLeakageConfig.size() << endl;
    if(!minLeakageConfig.empty()) return true;
    return false;
}
/*---------------------------------------------------------*/
void
PeepHole::reloadBestSizing(){
    //cout << "Reloading Best Sizing Configuration ..." << endl;
    map<oaModInst*,oaString>::iterator it;
    Util util;
    double newLeakagePower = 0.0;
    for(it=minLeakageConfig.begin(); 
	    it!=minLeakageConfig.end(); ++it){
	CellData *c = CellData::get(it->first);
	assert(c);
	c->swap(it->second);
	c->commitSwap();
	//cout << " " << c->instName << " " << c->master->name << endl;
	newLeakagePower += c->master->leakage_power;
	util.invalidateFanIOTiming(design,timing,c->inst);
    }
    timing->updateAll();
    /*std::cout << " New Leakage Power:" << newLeakagePower
	<< " Old Leak Power:" << leakage_sum << std::endl;*/
}
/*---------------------------------------------------------*/
void
PeepHole::reverseAllSizing(){
    map<oaModInst*,oaString>::iterator it;
    Util util;
    for(it=existingLibMasterMap.begin(); 
	    it!=existingLibMasterMap.end(); ++it){
	CellData *c = CellData::get(it->first);
	assert(c);
	c->swap(it->second);
	c->commitSwap();
	c->isMark = false;
	util.invalidateFanIOTiming(design,timing,c->inst);
    }
    timing->updateAll();
}
/*---------------------------------------------------------*/
void 
PeepHole::clear(){
    leakage_sum = 0;
    //root = NULL;
    if(!fanouts.empty()) fanouts.clear();
    empty = true;
    valid = false;
}
/*---------------------------------------------------------*/
// Functions below are for DEBUG ONLY
/*---------------------------------------------------------*/
void
PeepHole::print(){
    int id = 0;
    cout << "*** CURRENT PEEPHOLE DATA - FO Level:" << foLvl << "***" << endl;
    CellData *cell = CellData::get(root);
    assert(cell);
    std::cout << "1)Root: " << cell->instName << " - " << cell->master->name << 
	std::endl; //" Sensitivity:" << cell->fanoutSensitivity << endl;
    cout << " 2)" << foLvl << "-level-Fanout(s)" << " Size-" << fanouts.size() << ":\n";
    for(instVector::iterator p_it=fanouts.begin();p_it!=fanouts.end();++p_it){
	oaString s = Util::getInstName(*p_it);
	CellData *cell = CellData::get(*p_it);
	assert(cell);
	std::cout << "  " << s << ":" <<  cell->master->name << std::endl;
	cell->printTimingData(design,timing);
    }
    cout << " 3)FeasibleFanout(s)" << " Size-" << feasibleSwaps.size() << ":\n";
    for(swapVector::iterator svit=feasibleSwaps.begin();svit!=feasibleSwaps.end();++svit){
	CellData *cell = CellData::get(svit->inst);
	assert(cell);
	std::cout << "  " << cell->instName << ":" <<  cell->master->name << std::endl;
	cell->printTimingData(design,timing);
	std::cout << "   Current Leakage:" << subNetLeakage
	    << " New Net Leakage:" << feasibleNetLeakage << std::endl;
    }
    /*cout << "3)Eval Fanout(s)" << " Size-" << evalFanouts.size() << ":\n";
    for(BoundingMap::iterator ep_it=evalFanouts.begin(); ep_it!=evalFanouts.end();++ep_it){
	cout << " " << Util::getInstName(ep_it->first) 
	    << ":" << ep_it->second << "\n";
    }*/
    std::cout << "Leakage:" << leakage_sum << std::endl;
    cout << "********** END **************" << endl;
}
/*---------------------------------------------------------*/
void
PeepHole::printList(oaString s,vector<oaString> list){
    vector<oaString>::iterator st_it;
    for(st_it=list.begin(); st_it!=list.end(); ++st_it){
	std::cout << "    " << *st_it << std::endl;
    }
}
/*---------------------------------------------------------*/
}//namespace
