/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: Philip Chong <pchong@cadence.com>
*/

#if !defined(oagTimerLinearWireModel_P)
#define oagTimerLinearWireModel_P

#include "oaDesignDB.h"
#include "oagTimerWireModel.h"

using namespace oa;

namespace oagTimer {

/// A simple wire model class.
///
/// This class implements a simple wire delay model for the timer.
/// It is based on a linear wire delay model (the linear model is used
/// here to simulate the effect of optimal buffering;
/// see Otten, Brayton DAC 1998).
///
/// R/C values are taken from the metal3 layer of the given tech library.
/// Routing is estimated by assuming a wire with length equal to the
/// bounding box of the net and width the minimium wire width of the
/// metal3 layer.
///
/// \todo Check all units and make more efficient by not converting
/// everything to user units (use DB units instead).

class LinearWireModel : public WireModel {
  public:
    LinearWireModel(oaTech *tech = 0);

    /// Destructor.
    ~LinearWireModel() {
        // nothing
    }

    void set(oaTech *tech);

  public:
    double getWireCap(oaNet *net);
    DelayType getWireDelay(oaNet *net);

  private:
    /// Tech library to use
    oaTech *_tech;

    /// Capacitance per unit length.  Units are picofarads/DB units.
    /// \todo Check units.
    double _capPerLength;

    /// Resistance per unit length.  Units are ohms/DB units.
    /// \todo Check units.
    double _resPerLength;
};

}

#endif
