/************************************************************
* 
* File: oagTimerKickMove.cpp
* Author: Santiago Mok (smok@ee.ucla.edu)
* Created: 10-04-2010
* Last Modified: Wed 16 Feb 2011 11:25:02 AM PST
*
************************************************************/
#include "oagTimerKickMove.h"
#include "oagTimerDuetSensitivity.h"
#include "oagTimerUtil.h"

namespace oagTimer{
using namespace oa;
using namespace std;
/*---------------------------------------------------------*/
kickMove::kickMove(oaDesign *des, Timer *t){
    topDesign = des;
    timer = t;
}
kickMove::~kickMove(){}
/*---------------------------------------------------------*/
void
kickMove::restoreBestDesign(){
    std::cout << " ** Reloading Best Configuration ** " << std::endl;
    if(bestDesign.empty()){ 
	cout << "  no best design to load " << endl;
    }
    map<oaModInst*,oaString>::iterator iter;
    for(iter=bestDesign.begin(); iter!=bestDesign.end(); ++iter){
	CellData *cell = CellData::get(iter->first);
	assert(cell);
	cell->swap(iter->second);
	cell->commitSwap();
    }
    timer->clearDesignTimingData();
    timer->updateAll();
}
/*---------------------------------------------------------*/
void
kickMove::saveBestDesign(){
    bestDesign.clear();
    oaModule *mod = topDesign->getTopModule();
    oaIter<oaModInst> mIter(mod->getInsts());
    while(oaModInst *m = mIter.getNext()){
	CellData *c = CellData::get(m);
	assert(c);
	bestDesign[m] = c->master->name; 
    }
}
/*---------------------------------------------------------*/
void
kickMove::createUpsizeList(){
    kickMoves.clear();
    _N = 0;
    oaModule *mod = topDesign->getTopModule();
    oaIter<oaModInst> mIter(mod->getInsts());
    while(oaModInst *m = mIter.getNext()){
	++_N;
	CellData *c = CellData::get(m);
	assert(c);
	if(c->master->isSequential) continue;
	if(c->getUpSizeCount()) kickMoves.push_back(m);
    }
    if(kickMoves.empty()) cout << "*NO UPSIZE MOVE*" << endl;
}
/*---------------------------------------------------------*/
bool
kickMove::doUpsizing(){
    if(kickMoves.empty()) return false;
    Util ut;
    bool flag = false;
    double pctTotal = 0.05*_N;
    for(double i=0.0; i<pctTotal; ++i){
	int index = rand() % kickMoves.size();
	list<oaModInst*>::iterator it = kickMoves.begin();

	for(int j=0; j<index; ++j) ++it;
	CellData *cell = CellData::get(*it);
	assert(cell);
	kickMoves.erase(it);
	vector<oaString> upSizes = cell->getGreaterThanCurrentSize();
	if(upSizes.empty()) continue;
	for(int k=upSizes.size()-1; k>=0; k--){
	    cell->swap(upSizes[k]);
	    ut.invalidateFanIOTiming(topDesign,timer,cell->inst);
	    timer->updateAll();
	    double wSlack = timer->getWorstSlack();
	    if(wSlack < 0){
		cell->reverseSwap();
		ut.invalidateFanIOTiming(topDesign,timer,cell->inst);
		timer->updateAll();
	    }else{
		cell->commitSwap();
		flag = true;
		break;
	    }
	}
    }
    return flag;
}
/*---------------------------------------------------------*/
void
kickMove::doOneOpt(){
    DuetSensitivity duetOpt(topDesign,timer);
    //duetOpt.flag = true;
    duetOpt.run();
}
/*---------------------------------------------------------*/
void
kickMove::run(int max){

    double currBestLeakagePower = Util::getTotalLeakPower(topDesign); 

    saveBestDesign();
    int MAX_ITER = max;
    int totalTrial = 0;
    time_t start, end;
    double tcPeriod = timer->getPeriod();
    cout << " Initial LeakagePower:" << currBestLeakagePower <<
      " Period:" << tcPeriod << endl; 
    time(&start);
    for(int i=0; i<MAX_ITER; ++i){
	++totalTrial;
	createUpsizeList();
	bool swapTaken = doUpsizing();
	if(!swapTaken) continue;
	cout << " KickMove - LeakagePower:" << Util::getTotalLeakPower(topDesign) << endl;
	doOneOpt();
	double worstArr = timer->getWorstArr();
	if(worstArr < 0.0) cout << "* Error: Timing violated *" << endl;
	double newLeakagePower = Util::getTotalLeakPower(topDesign);
	if(newLeakagePower < currBestLeakagePower){
	    currBestLeakagePower = newLeakagePower;
	    saveBestDesign();
	    cout << " Best Design Saved - Power:" << newLeakagePower << endl;
	}
    }

    restoreBestDesign();
    time(&end);
    cout << " Total Trials:" << totalTrial << endl;
    cout << " Final LeakagePower:" << Util::getTotalLeakPower(topDesign) << endl; 
    cout << " Total Iterations: " << max << endl;
    cout << " Time:" << difftime(end,start) << endl;
}
/*---------------------------------------------------------*/
} //namespace
