/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

// Author: Zhong Xiu <zxiu@andrew.cmu.edu>

#include "oagTimerInstTermObserver.h"
#include "oagTimerTimer.h"
#include "oagTimerTPoint.h"

namespace oagTimer {

using namespace oa;

InstTermObserver::InstTermObserver(oaUInt4      priority,
                                   oaBoolean    enabled) :
    oaObserver<oaOccInstTerm>(priority, enabled)
{
    // do nothing
}

void
InstTermObserver::onPostCreate(oaOccInstTerm *instTerm)
{
    TPoint::create(instTerm);
};

void
InstTermObserver::onPreModify(oaOccInstTerm         *instTerm,
                              oaInstTermModTypeEnum modType)
{
    if (modType == oacRemoveFromNetInstTermModType) {
        invalidate(instTerm);
    }
};

void
InstTermObserver::onPostModify(oaOccInstTerm            *instTerm,
                               oaInstTermModTypeEnum    modType)
{
    if (modType == oacAddToNetInstTermModType) {
        invalidate(instTerm);
    }
};

void
InstTermObserver::onPreDestroy(oaOccInstTerm *instTerm)
{
    TPoint::destroy(instTerm);
};

void
InstTermObserver::invalidate(oaOccInstTerm *instTerm)
{
    assert(instTerm);
    oaOccNet *n = instTerm->getNet();
    assert(n);
    Timer::invalidateFanout(n);
    Timer::invalidateFanin(n);
}

}
