/************************************************************
* 
* File: oagTimerCellMaster.h
* Author: Santiago Mok (smok@ee.ucla.edu)
* Created: 05-13-2010
* Last Modified: Sat 19 Mar 2011 12:38:20 PM PDT
*
************************************************************/
#if !defined(oagCellMaster_P)
#define oagCellMaster_P

#include <assert.h>
#include <list>
#include "string.h"

#include "oaDesignDB.h"
#include "oagTimerLibData.h"
#include "oagTimerLibParserInt.h"
#include "oagTimerUtil.h"


namespace oagTimer {
/*---------------------------------------------------------*/
using namespace std;
using namespace oa;
/*---------------------------------------------------------*/
/*!
 * CellMaster class defines each cell sizes/strengths defined in the
 * standar .lib library. This class also contain other cell sizes 
 * found in the .lib with respect to the current cell type (i.e. NAND2).
 * It is used to do gate sizing optimization. 
 */

/*! TO DO
 * 1) Stores power-related data from the .lib library
 */
class CellMaster {
  friend class CellData;
  friend class LibData;
  friend class Timer;
  friend class Util;
  //friend class Opt;
  //friend class PeepHole;

  public:
    CellMaster(){
	name = oaString(); 
	area = 0;
	leakage_power = 0;
	isSequential = false;
    }
    ~CellMaster(){}

  public:
    /*! The lib cell name for this cell master. (i.e. NAND2_X4)*/
    oaString name;
    /*! The cell type for this cell master. (i.e. NAND2)*/
    oaString basename;
    /*! Footprint read from the liberty library file (i.e. NAND2). */
    oaString footprint;
    /*! Drive strength of current cell. (i.e. 4)*/
    double strength;
    /*! The cell area for this cell master.*/
    double area;
    /*! The leakage power for this cell master.*/
    double leakage_power;
    /*! Distinguish between sequential and combinational logic. */
    bool isSequential;

/*---------------------------------------------------------*/
/*! Class Function */
    /*! Set the current lib name for this CellMaster and decompose
     * its basename and drive strength.
     */
    void setLibCellName(const char *s);
/*---------------------------------------------------------*/
/*! AppDefs Definitions */
  private:
    static oaVoidPointerAppDef<oaModule> *_modAppDef;

    /// Initialize the appDefs associated with CellMasters.
    static void initAppDefs();
    
    /// Create a CellMaster for the given Mod.
    ///
    /// It is a fatal error to try to create a CellMaster
    /// for a Mod which already has a CellMaster.
    ///
    /// \param inst The Mod for which to create CellMaster.
    /// \return The new CellMaster.
    static CellMaster *create(oaModule *mod);

    /// Get the CellMaster for the given Mod, or 0 if 
    /// the Mod has no CellMaster.
    ///
    /// \param inst The ModInst to query.
    /// \return The corresponding CellMaster.
    static CellMaster *get(oaModule *mod);
/*---------------------------------------------------------*/
/*! DEBUG INFORMATION */
  public:
    void printCellData();
}; //class 

}//namespace
#endif //define
