#include "lpSA.h"
#include "oagTimerTimerUtil.h"
#include "oagTimerReport.h"
#include "oagTimerSubTimer.h"
//#include "oagTimerUtilInt.h"
#include <time.h>


#define DTMIN_BD 1

//#define DEBUG
//namespace tg {
using namespace oa;
using namespace std;
using namespace solver;

namespace oagTimer {

  /* modify following functions */
  lpSA::lpSA(oaDesign *des, Timer* t) {
    topDesign = des;
    timer = t;
    _N = 0;

  }

  //Find slack allocated and change to a size that meet timing
  /*void sensInfo::assign(double d) {
    // int ind = getInd(d);
    // set node in sensInfo to vth data[ind].vth;
    // set node in sensInfo to size data[ind].size;
  }*/
  
  /* Find the gate index for slack allocation d */
  void sensInfo::assign(oaDesign *dsgn, Timer *t, double d) {
     // Compute the sensitivity for a given d 
    if (d > DTmax) {
      double dt = d;
      if (dt < 1e-5)
        dt = 1.0;
      if ((fabs(d-DTmax)/dt) > 1e-6) {
        cout << "d is greater than DTmax!" << endl;
        assert(0);
      }
    }
    
    Util ut;
    CellData *cell = CellData::get(inst->getModInst());
    assert(cell);
    cell->swap(origSize);
    ut.invalidateFanIOTiming(dsgn,t,cell->inst);
    t->updateAll();
    double wOrigSlack = Util::getWorstInputSlack(t,cell->occInst);
    double worstOrigArr = t->getArr(DesignTool::getOccOutInstTerm(cell->occInst));
    cell->reverseSwap();
    //cout << " CurrInst:" << Util::getInstName(inst) << " Alloc:" << d << " DT:" << DTmin << " / " << DTmax << std::endl;
    int n = data.size();
    for (int i=n-1; i >= 0; --i){
    //for (int i=1; i < n-1; ++i){
      // loop through the sensitivity tokens (data[i]), and check the change in arrival time or slack
	//std::cout << " " << data[i].name << endl;
 	/*std::cout << " DTminInd:" << DTminInd << std::endl;*/
	cell->swap(data[i].name);
	ut.invalidateFanIOTiming(dsgn,t,cell->inst);
	t->updateAll();
	double currSlack = Util::getWorstInputSlack(t,cell->occInst);
	double worstCurrArr = t->getArr(DesignTool::getOccOutInstTerm(cell->occInst));
	double dSlack = wOrigSlack - currSlack;
	double worstGlobalSlack = t->getWorstSlack();
	if((dSlack <= d) && (currSlack >= 0) && (worstGlobalSlack >= 0)){ 
	    cell->commitSwap();
	    break;
	}else{
	    cell->reverseSwap();
	    ut.invalidateFanIOTiming(dsgn,t,cell->inst);
	    t->updateAll();
	}
    }
  } //getInd()  

  void lpSA::run() {
    
    double getTopDes_t, createSens_t, slackAlloc_t, saveDesign_t, assign_t, reloadDesign_t, updateTokens_t;
    time_t start; 
    time_t t1, t2, t3, t4, t5, t6, t7, t8;
    time_t end;
    time (&start);

    topDsgn = DesignTool::getTopological(topDesign,timer);
    time(&t1);
    getTopDes_t = difftime(t1,start);

    makeSensInfo();
    time(&t2);
    createSens_t = difftime(t2,t1);

    _N = _sensInfo.size();
    tcPeriod = Tc =  timer->getPeriod();
    double pmin = ut.getTotalLeakPower(topDesign); 
    double tmin = tcPeriod;
    
    double prevLeakagePower = 0.0;
    double currLeakagePower = pmin;

    cout << "Running LP based slack assignment ... " <<  _N <<  " instances" << endl;
    cout << " Given Timing Constraint:" << tcPeriod << " initial power:" << pmin << endl;
    for (int i = 0; i < 100; ++i) {
      cout << "Iteration " << i << endl;
      time(&t3);
      int ret;
      if (i == 0)
        { ret = iSA();} // Initial Slack allocation
      else
        { ret = rSA();} // re-slack allocation
      time(&t4);
      slackAlloc_t += difftime(t4,t3);

      saveCurrSizing();
      time(&t5);
      saveDesign_t += difftime(t5,t4);

      assign();
      checkAssign();
      double totalLeakagePower = ut.getTotalLeakPower(topDesign);
      double wArr = timer->getWorstArr();
      double wSlack = timer->getWorstSlack();
      time(&t6);
      assign_t += difftime(t6,t5);

      if(wSlack < 0.0){
	  reloadSizing();
	    time(&t7);
	    reloadDesign_t += difftime(t7,t6);
	  prevLeakagePower = 0.0;
      }else if ((totalLeakagePower < pmin)) {
	pmin = totalLeakagePower;
	updateToken();
	save();
	  time(&t7);
	  updateTokens_t += difftime(t7,t6);
	prevLeakagePower = 0.0;
        cout << " worstArr:" << wArr << "/ wslack:" << wSlack << " / totalLeakage:" << totalLeakagePower << endl;
	continue;
      }
      //printCurrConfig();
      cout << "power: " << pmin 
	  << "/" << totalLeakagePower << " arr: " << wArr << "/ " << tcPeriod << endl;
      if(wSlack >= 0.0){
	  double dPowerImpr = fabs(totalLeakagePower - prevLeakagePower)/totalLeakagePower;
	  if(dPowerImpr < 1e-4){ 
              std::cout << "dPower Imprv: " << dPowerImpr << ", ending LP OPT" << std::endl;
	      break;
	  }
      }
      if (ret == -1) {
          cout << "Solver difficulties - slack may be too small" << endl;
          break;
      }
      prevLeakagePower = totalLeakagePower;
    }
    
    /* Reload best sizes */
    if (pmin != DBL_MAX)
	reload(); 
    //free_lp(&_lp); /* free the lp */
    delete(_lp);

    time (&end);
    std::cout << "Total Runtime:" << difftime(end,start) << " (s)" << std::endl;
    std::cout << " RunTime Breakdown - " << std::endl;
  } //lpSA::ruN()
  
  void lpSA::updateToken(){
    makeSensInfo();
    _N = _sensInfo.size();
  }

  void lpSA::saveCurrSizing(){
    if(!currSizing.empty()) currSizing.clear();
    oaModule *mod = topDesign->getTopModule();
    oaIter<oaModInst> mIter(mod->getInsts());
    while(oaModInst *m = mIter.getNext()){
	CellData *c = CellData::get(m);
	assert(c);
	currSizing[m] = c->master->name; 
    }
  }
  void lpSA::reloadSizing(){
      map<oaModInst*,oaString>::iterator it;
      for(it=currSizing.begin(); it!=currSizing.end(); ++it){
	  CellData *c = CellData::get(it->first);
	  assert(c);
	  c->swap(it->second);
	  c->commitSwap();
	  ut.invalidateFanIOTiming(topDesign,timer,c->inst);
      }
      timer->updateAll();
  }

  void lpSA::printCurrConfig() {
    // Save the configuration for later 
    std::cout << " ** Print Current Configuration ** " << std::endl;
    for(int n=0; n<_N; ++n){
	oaModInst *m = _sensInfo[n].inst->getModInst();	
	CellData *c = CellData::get(m);
	assert(c);
	cout << " " << c->instName << " : " << c->master->name << endl;
    }
  }

  void lpSA::save() {
    // Save the configuration for later 
    std::cout << " ** Saving Best Configuration ** " << std::endl;
    bestDesign.clear();
    oaModule *mod = topDesign->getTopModule();
    oaIter<oaModInst> mIter(mod->getInsts());
    while(oaModInst *m = mIter.getNext()){
	CellData *c = CellData::get(m);
	assert(c);
	bestDesign[m] = c->master->name; 
    }
  }
  
  void lpSA::reload() {
    // reload saved design 
    std::cout << " ** Reloading Best Configuration ** " << std::endl;
    if(bestDesign.empty()){ 
	cout << "  no best design to load " << endl;
	return;
    }
    map<oaModInst*,oaString>::iterator iter;
    for(iter=bestDesign.begin(); iter!=bestDesign.end(); ++iter){
	CellData *cell = CellData::get(iter->first);
	assert(cell);
	cell->swap(iter->second);
	cell->commitSwap();
	//ut.invalidateFanIOTiming(topDesign,timer,cell->inst);
    }
    timer->clearDesignTimingData();
    timer->updateAll();
  }
  
  /* For a given instance / gate instance, fill the data vector with sensitivity tokens */
  void sensInfo::modelSens(oaDesign *d, Timer *t, CellData *cell) {
#if defined(DEBUG)
      std::cout << "modelSens()" << std::endl;
#endif
    // Get a list of the different sizes  
    size = cell->master->strength; //current size;
    double currLeakPower = cell->master->leakage_power;
    
    int n1 = 0;
    data.clear();
    
    // Find the max range index 
    vector<oaString> otherSizes = cell->getLessThanCurrentSize(); 
    // create token for current size 
    otherSizes.push_back(cell->master->name);
    n1 = otherSizes.size(); 
    if(n1 == 0){ 
	DTmin = DBL_MAX;
	return;
    }
    // loop through all the gate sizes 
    double wOrigSlack = Util::getWorstInputSlack(t,cell->occInst);
    Util ut;
    for (int i = 0; i < n1; ++i) {
      oaString newSize = otherSizes[i];
      sensToken cST;
      cST.name = newSize;
	cell->swap(cST.name);
	ut.invalidateFanIOTiming(d,t,cell->inst);
	t->updateAll();
	double wCurrSlack = Util::getWorstInputSlack(t,cell->occInst);
	cST.DT = (wOrigSlack - wCurrSlack);

	// Change in the power 
	cST.DP = double (Util::getCellLeakagePower(newSize)-currLeakPower); 
      oaString base;
      double size = 0;
      Util::parseLibCellName(newSize,base,size);
      cST.size = size; 
      data.push_back(cST);
      cell->reverseSwap();
      ut.invalidateFanIOTiming(d,t,cell->inst);
      t->updateAll();
    }
    
    if (data.size() > 1)
      sort(); // sorts sensitivities
    
    DTmax = data[data.size()-1].DT;
    DTmin = data[0].DT;
    DTminInd = 0;
    
    //cout << DTmin << ", " << DTmax << endl;
    
  } //sensInfo::modelSens();
  
  /* Return the index of the gate that drives the given gate input param */
  int lpSA::getDriverIndex(oaOccInstTerm *i){
      oaOccNet *net = i->getNet();
      TPoint *pin = TPoint::get(i);
      if(pin->isFromPI){
	  oaIter<oaOccTerm> tIter = net->getTerms();
	  while(oaOccTerm *term = tIter.getNext()){
	      TPoint *tp = TPoint::get(term);
	      assert(tp);
	      return tp->index;
	  }
      }
      oaIter<oaOccInstTerm> iIter = net->getInstTerms();
      while(oaOccInstTerm *iTerm = iIter.getNext()){
      oaTermType type(iTerm->getTerm()->getTermType());
	  if(type == oacOutputTermType){
	      CellData *c = CellData::get(iTerm->getInst()->getModInst());
	      assert(c);
	      return c->index;
	  }
      }
  }
  
  bool lpSA::checkSlack = false;
  
  /* Initial slack allocation step */
  int lpSA::iSA() {
    if (lpSA::checkSlack) 
	s.initializeSolver(2*_N+1); // # OF VARIABLES
    else
	s.initializeSolver(3*_N); // # OF VARIABLES

    /*if (lpSA::checkSlack) 
      _lp = make_lp(0, 2*_N+1); //Original
    else
      _lp = make_lp(0, 3*_N); //Original
    */ 
    int varIndex[3*_N];
    double varCoeff[3*_N];

    int riseOffset, fallOffset, slackOffset;
    if (lpSA::checkSlack) {
      riseOffset = 1;
      fallOffset = _N+1;
      slackOffset = 0; // not used
    }
    else {
      slackOffset = 1;
      riseOffset = _N+1;
      fallOffset = 2*_N+1;
    }

    // Add constraints 
    //set_add_rowmode( _lp, TRUE);
    
    for(int n=0; n<_N; ++n){ 
      double t0 = 0; double t, t1, t2;
      
      // Loop over all the input pins
	oaIter<oaOccInstTerm> itIter = (_sensInfo[n].inst)->getInstTerms();	
	while(oaOccInstTerm *oit = itIter.getNext()){ 
	    TPoint *pin = TPoint::get(oit);
	    bool inverting = false;
	    if(pin->inverting) inverting = true;
	    if(pin->type == TIMING_POINT_SIGNAL_IN){
		// Get the input term / gate 
		double rise_delay = Util::getCellRiseDelay(oit);
		double fall_delay = Util::getCellFallDelay(oit);

		// add wire delay with respect to current input arc for PI only
		rise_delay += pin->netDelay;
		fall_delay += pin->netDelay;

		if (lpSA::checkSlack) {
		  varIndex[0] = riseOffset + n;     varCoeff[0] =  1.0;  // a_n_rise
		  varIndex[1] = 2*_N + 1;           varCoeff[1] = -1.0;  // a_max
		  s.addConstraint(2, varCoeff, varIndex, BD_LE, 0.0);
		  //add_constraintex(_lp, 2, varCoeff, varIndex, LE, 0.0); 
		  
		  varIndex[0] = fallOffset + n;     varCoeff[0] =  1.0;  // a_n_rise
		  varIndex[1] = 2*_N + 1;           varCoeff[1] = -1.0;  // a_max
		  s.addConstraint(2, varCoeff, varIndex, BD_LE, 0.0);
		  //add_constraintex(_lp, 2, varCoeff, varIndex, LE, 0.0);

		}

		// If there is a source input, write input delay 
		if(pin->isFromPI || pin->isFromFF){
		    // s_n + t (wire/gate delay) \leq a_n
		    // Variable are +1'ed to fix numbering
		  if(pin->isFromFF){
			// Remove net delay from rise_delay to avoid double counting net delay
			// which has already be accounted for in the Arrival Time
			rise_delay -= pin->netDelay;
			fall_delay -= pin->netDelay;

		      if(inverting){
			  fall_delay += timer->getRiseArr(oit);
			  rise_delay += timer->getFallArr(oit);
		      }else{
			  rise_delay += timer->getRiseArr(oit);
			  fall_delay += timer->getFallArr(oit);
		      }
		  }
		  if (lpSA::checkSlack) {
		    varIndex[0] = riseOffset + n; varCoeff[0] = -1.0;  // a_n(rise)
		    s.addConstraint(1, varCoeff, varIndex, BD_LE, -rise_delay);
		    //add_constraintex(_lp, 1, varCoeff, varIndex, LE, -rise_delay);
		    
		    varIndex[0] = fallOffset + n; varCoeff[0] = -1.0;  // a_n(fall)
		    s.addConstraint(1, varCoeff, varIndex, BD_LE, -fall_delay);
		    //add_constraintex(_lp, 1, varCoeff, varIndex, LE, -fall_delay);
		    continue;
		  }
		  else {

		    varIndex[0] = slackOffset + n;  varCoeff[0] =  1.0;  // s_n
		    varIndex[1] = riseOffset  + n;  varCoeff[1] = -1.0;  // a_n(rise)
		    s.addConstraint(2, varCoeff, varIndex, BD_LE, -rise_delay);
		    //add_constraintex(_lp, 2, varCoeff, varIndex, LE, -rise_delay);

		    varIndex[0] = slackOffset + n;  varCoeff[0] =  1.0;  // s_n
		    varIndex[1] = fallOffset  + n;  varCoeff[1] = -1.0;  // a_n
		    s.addConstraint(2, varCoeff, varIndex, BD_LE, -fall_delay);
		    continue;
		  }
		}
		int i = getDriverIndex(oit);
		// Include wire delay: t = t'+w
		// Write constraint
		// a_i + s_n + (w_in + t) (wire/gate delay) \leq a_n 
		// Variable are +1'ed to fix numbering 
		if (lpSA::checkSlack) {
		  if (inverting){
		    varIndex[0] =  fallOffset + i; varCoeff[0] =  1.0;  // a_i(fall)
		  }else{
		    varIndex[0] =  riseOffset + i; varCoeff[0] =  1.0;  // a_i(rise)
		  }
		  varIndex[1] =    riseOffset + n; varCoeff[1] = -1.0;  // a_n
		  s.addConstraint(2, varCoeff, varIndex, BD_LE, -rise_delay);
		  //add_constraintex(_lp, 2, varCoeff, varIndex, LE, -rise_delay);

		  if (inverting){
		    varIndex[0] =  riseOffset + i; varCoeff[0] =  1.0;  // a_i(fall)
		  }else{
		    varIndex[0] =  fallOffset + i; varCoeff[0] =  1.0;  // a_i(rise)
		  }
		  varIndex[1] =    fallOffset + n; varCoeff[1] = -1.0;  // a_n
		  s.addConstraint(2, varCoeff, varIndex, BD_LE, -fall_delay);
		  //add_constraintex(_lp, 2, varCoeff, varIndex, LE, -fall_delay);
		}
		else {
		  oaOccInstTerm *outTerm = DesignTool::getOccOutInstTerm(oit->getInst()); 
		  TPoint *outPin = TPoint::get(outTerm);
		  assert(outPin);
		  if(outPin->isToFF){
		      double setupTime = timer->getSetupTime(outTerm);
		      rise_delay += setupTime;
		      fall_delay += setupTime;
		  }
		  if (inverting){
		    varIndex[0] = fallOffset + i; varCoeff[0] =  1.0;   // a_i(fall)
		  }else{
		    varIndex[0] = riseOffset  + i; varCoeff[0] =  1.0;  // a_i(rise)
		  }
		  varIndex[1] =   slackOffset + n; varCoeff[1] =  1.0;  // s_n
		  varIndex[2] =   riseOffset  + n; varCoeff[2] = -1.0;  // a_n(rise)
		  s.addConstraint(3, varCoeff, varIndex, BD_LE, -rise_delay);
		  //add_constraintex(_lp, 3, varCoeff, varIndex, LE, -rise_delay);

		  if (inverting){
		    varIndex[0] = riseOffset + i; varCoeff[0] =  1.0;   // a_i(rise)
		  }else{
		    varIndex[0] = fallOffset  + i; varCoeff[0] =  1.0;  // a_i(fall)
		  }
		  varIndex[1] =   slackOffset + n; varCoeff[1] =  1.0;  // s_n
		  varIndex[2] =   fallOffset  + n; varCoeff[2] = -1.0;  // a_n(fall)
		  s.addConstraint(3, varCoeff, varIndex, BD_LE, -fall_delay);
		  //add_constraintex(_lp, 3, varCoeff, varIndex, LE, -fall_delay);
		}
	    }
	}
    }
    // Constraints END 
    //set_add_rowmode( _lp, FALSE);
    
    int k = 0;
    if (lpSA::checkSlack) {
	
	for (int n = 0; n < _N; ++n) {
	    varIndex[0] = riseOffset + n; varCoeff[0] = 1.0;
	    varIndex[1] = 2*_N+1;         varCoeff[1] = -1.0;
	    s.addConstraint(2, varCoeff, varIndex, BD_LE, 0.0);
	    
	    varIndex[0] = fallOffset + n; varCoeff[0] = 1.0;
	    varIndex[1] = 2*_N+1;         varCoeff[1] = -1.0;
	    s.addConstraint(2, varCoeff, varIndex, BD_LE, 0.0);
	}
    
      varIndex[k] = 2*_N + 1 ;
      varCoeff[k++] = 1.0; //minimize slack
    }
    else {
      // Write the objective
      for (int n = 0; n < _N; ++n) {
	double t = _sensInfo[n].getSens(_allocSlack[n]); // get the sens
	s.setBound((n+slackOffset), _sensInfo[n].DTmin, _sensInfo[n].DTmax);
	//set_bounds( _lp, (n+slackOffset), _sensInfo[n].DTmin, _sensInfo[n].DTmax);
	s.setUpperBound((riseOffset + n), Tc);
	s.setUpperBound((fallOffset + n), Tc);
	//set_upbo( _lp, (riseOffset + n), Tc);
	//set_upbo( _lp, (fallOffset + n), Tc);
	if (t != 0.0) {
	  varIndex[k] = n + slackOffset;
	  varCoeff[k++] = t;
	}
      }
    }
    s.setObjective(k, varCoeff, varIndex);
    /*set_obj_fnex(_lp, k, varCoeff, varIndex);
    set_minim(_lp);
    set_verbose(_lp, IMPORTANT);*/
    
    /*if (0) {
      // Check LP
      char name[10];
      for (int i= 1; i <= _N; ++i) {
        sprintf(name, "d%d", i);
        set_col_name( _lp, i, name);
      }
      for (int i= (_N+1); i <= (2*_N); ++i) {
        sprintf(name, "a%d", (i-_N));
        set_col_name( _lp, i, name);
      }
      write_LP( _lp, stdout);
    }*/
    _lp = new double [3*_N]; 
    for(int i=0; i<(3*_N); i++){
	_lp[i] = 0;
    }
    int ret = s.solveLP(_lp);
    std::cout << "solver returned:" << ret << std::endl;
    //int ret = solve(_lp);
    
    //if (ret == OPTIMAL) {
    if (ret == 1) {
	std::cout << "getVariables" << std::endl;
	for(int i=0; i<(3*_N); i++){
	    varCoeff[i] = _lp[i];
	    //std::cout << _lp[i] << " " << varCoeff[i] << std::endl;
	}
      //get_variables(_lp, varCoeff);
      if (lpSA::checkSlack) {
	cout << "Min arrival time for the graph: " << varCoeff[2*_N] << endl;
	for (int i = 0; i < _N; ++i) {
	  cout << "Index "  << i+1 << " arrival time r: " << varCoeff[riseOffset + i - 1]
	       << " / f: " << varCoeff[fallOffset + i - 1]
	       << " : oa_rise" << timer->getRiseArr(DesignTool::getOccOutInstTerm(_sensInfo[i].inst)) 
	       << " oa_fall" << timer->getFallArr(DesignTool::getOccOutInstTerm(_sensInfo[i].inst)) 
	       << endl;
	}
      }
      else {
	_allocSlack.clear();
	for (int n = 0; n < _N; ++n) {
	  _allocSlack.push_back(varCoeff[n + slackOffset -1]);
	}
      }
      return 1;
    }
    else {
      cout << "Check solver" << endl;
      return 0;
    }
    
  } //iSA()
  

  
  /* realloc slack after iSA (recompute sens coeffs) */
  void lpSA::checkAssign() {
    double worstArr = timer->getWorstArr();
    double worstSlack = timer->getWorstSlack();
    float totalLeakagePower = ut.getTotalLeakPower(topDesign);

    //cout << "** " << totalLeakagePower << " " << worstArr << " " << tcPeriod << endl;
    //if ( worstArr > tcPeriod) {
    if ( worstSlack < 0.0 ) {
      //Tc += .1*(tcPeriod - worstArr);
      Tc += .1*worstSlack;
      cout << "** adjusting constraints ..." << Tc << "/" << tcPeriod << endl;
    }
    //cout << "** Iterate Adjustment:" << worstArr << "/" << tcPeriod << endl;
//    //saTmax += (timingGraph::getClockPeriod()- _tg->maxDelay);

    
    //if (( worstArr <= tcPeriod) && (DTMIN_BD)) {
    if (( worstSlack >= 0.0) && (DTMIN_BD)) {
      //for (int n = 0; n < _N; ++n) { 
        //if ((int) _sensInfo[n].data.size() > (_sensInfo[n].DTminInd + 1)) {
          //if (_sensInfo[n].data[(_sensInfo[n].DTminInd + 1)].DT <= _allocSlack[n]) {
            //++_sensInfo[n].DTminInd;
            //_sensInfo[n].DTmin = _sensInfo[n].data[_sensInfo[n].DTminInd].DT;
          //}
	  //}
      //}
    }
  
  } //checkAssign()

  /***********************************************************/
  /* I don't think you need to modify below here             */
  /***********************************************************/
  
  void lpSA::assign() {
    int ac = 0;
    
    // Write the objective 
    for (int n = 0; n < _N; ++n) {
      _sensInfo[n].assign(topDesign, timer, _allocSlack[n]); // get the sens for prev alloc slack 
      if (_allocSlack[n] > 1e-5)
        ++ac;
    }
    //cout <<"alloc card: " << ac << "/" << _N << endl;
  } //lpSA::assign()

  double sensInfo::getSens(double d) {
    // Compute the sensitivity for a given d
    int n = data.size();
    int ind = 0;
    
    if (n == 1)
      return 0.0;
    
    if (d > DTmax) {
      double dt = d;
      if (dt < 1e-5)
        dt = 1.0;
      if ((fabs(d-DTmax)/dt) > 1e-6) {
        cout << "d is greater than DTmax!" << endl;
        assert(0);
      }
    }
    
    oaNativeNS ns;
    oaString name;
    //cout << "Computing Sens for d:" << d << endl;
    for (int i = 0; i < n; ++i) {
	/*std::cout << (inst->getName(ns,name),name) 
	    << "(" << origSize << "->" << data[i].name << "):" << DTmin << "/" << DTmax
	    << " " << data[i].DP << "/" << data[i].DT << std::endl;*/
      if (d > data[i].DT) {
        ind = i;
      }
    }
    double dt = (data[ind+1].DT - data[ind].DT);
    double sens;
    if (dt == 0.0) {
        sens = 0.0;
    } else {
        sens = ((data[ind+1].DP - data[ind].DP)/(dt));
    }
    //std::cout << " index:" << ind << " " << sens << std::endl;
    return sens; 
    
  } //getSens()
  
  void sensInfo::sort() {
    // Sort the sens tokens for easy use
    int n = data.size();
    sensToken copyData[n];
    sensToken t1;
    
//    cout << "Before sort" << endl;
//    printf("(s:%d, vth:%d), DT:%6.2e, DP: %6.2e\n", data[0].size, data[0].vth, data[0].DT, data[0].DP);
//    for (int i = 1; i < n; ++i) {
//      printf("(s:%d, vth:%d), DT:%6.2e, DP: %6.2e\n", data[i].size, data[i].vth, data[i].DT, data[i].DP);
//    }

    // Bubble sort
    int loop = 1;
    while (loop) {
      loop = 0;
      for (int i = 1; i < n; ++i) {
        if (data[i].DT < data[i-1].DT) {
          // Swap the two
          t1 = data[i-1];
          data[i-1] = data[i];
          data[i] = t1;
          loop = 1;
        }
      }
    }
    
    int k = 1;
    copyData[0] = data[0];
    
    //cout << "After sort" << endl;
    //printf("(s:%d, vth:%d), DT:%6.2e, DP: %6.2e\n", data[0].size, data[0].vth, data[0].DT, data[0].DP);
    
    // Check for pareto optimality (remove non-pareto points)
    for (int i = 1; i < n; ++i) {
      //printf("(s:%d, vth:%d), DT:%6.2e, DP: %6.2e\n", data[i].size, data[i].vth, data[i].DT, data[i].DP);
      if (data[i].DP < copyData[k-1].DP) {
        copyData[k] = data[i];
        ++k;
      }
    }
    
    data.clear();
    //cout << "After PO" << endl;
    for (int i = 0; i < k; ++i) {
      //printf("(s:%d, vth:%d), DT:%6.2e, DP: %6.2e\n", data[i].size, data[i].vth, data[i].DT, data[i].DP);
      data.push_back(copyData[i]);
    }
  } //sort()

  void lpSA::makeSensInfo() {
#if defined(DEBUG)
      std::cout << "makeSensInfo" << std::endl;
#endif
    oaOccurrence *occ = topDesign->getTopOccurrence();
    assert(occ);
    _sensInfo.clear();
    _allocSlack.clear();
    int n = -1;
    /*oaIter<oaOccTerm> tIter = occ->getTerms();
    while(oaOccTerm *term = tIter.getNext()){
	TPoint *pin = TPoint::get(term);
	if(pin->type == TIMING_POINT_PI){
	    pin->index = ++n;
	}
    }*/
    int size = topDsgn.size();
    //for each gate in the design
    for(int i=0; i<size; ++i){
      oaModInst *inst = topDsgn[i];
      oaOccInst *occInst = DesignTool::getOccInst(topDesign,inst);
      sensInfo tSI;
      CellData *cell = CellData::get(inst);
      assert(cell);
      if(cell->master->isSequential) continue; //Skip FlipFlop for sizing
      tSI.modelSens(topDesign,timer,cell);
      if(tSI.DTmin == DBL_MAX) continue;
      tSI.inst = occInst;
      cell->index = ++n;
      //tSI.wInSlack = Util::getWorstInputSlack(timer,i);
      tSI.origSize = cell->master->name;
      //std::cout << cell->instName << " indx:" << n << std::endl; 
      _allocSlack.push_back(tSI.DTmin);
      _sensInfo.push_back(tSI);
    }
  } //makeSensInfo

  /* realloc slack after iSA (recompute sens coeffs) */
  int lpSA::rSA() {
    int varIndex[3*_N];
    double varCoeff[3*_N];
    
    int riseOffset, fallOffset, slackOffset;
    slackOffset = 1;
    riseOffset = _N+1;
    fallOffset = 2*_N+1;
    
    if (lpSA::checkSlack) { 
      cout<< "rSA does not perform check slack, please set lpSA::checkSlack = false" << endl;
      return 0;
    }

    // Write the objective 
    int k = 0;
    for (int n = 0; n < _N; ++n) {
      double t = _sensInfo[n].getSens(_allocSlack[n]); // (alloc slack is recomputed)
      s.setBound((n+slackOffset), _sensInfo[n].DTmin, _sensInfo[n].DTmax);
      //set_bounds( _lp, (n+1), _sensInfo[n].DTmin, _sensInfo[n].DTmax);
      s.setUpperBound((n + riseOffset), Tc);
      s.setUpperBound((n + fallOffset), Tc);
      //set_upbo( _lp, (_N + n+1), Tc);
      if (_sensInfo[n].DTmin > _sensInfo[n].DTmax)
        assert(0);
      if (t != 0.0) {
        varIndex[k] = n + slackOffset;
        varCoeff[k++] = t;
      }
    }
    
    s.setObjective(k, varCoeff, varIndex);
    /*set_obj_fnex(_lp, k, varCoeff, varIndex);
    
    set_minim(_lp);
    set_verbose(_lp, IMPORTANT);*/
    
    /*if (0) {
      // Check LP
      char name[10];
      for (int i= 1; i <= _N; ++i) {
        sprintf(name, "d%d", i);
        set_col_name( _lp, i, name);
      }
      for (int i= (_N+1); i <= (2*_N); ++i) {
        sprintf(name, "a%d", (i-_N));
        set_col_name( _lp, i, name);
      }
      write_LP( _lp, stdout);
    }*/
    
    
    int ret = s.solveLP(_lp);
    //int ret = solve(_lp);
    //if (ret == OPTIMAL) {
    if (ret == 1) {
	for(int i=0; i<(3*_N); i++){
	    varCoeff[i] = _lp[i];
	    //std::cout << _lp[i] << " " << varCoeff[i] << std::endl;
	}
      //get_variables(_lp, varCoeff);
      _allocSlack.clear();
      for (int n = 0; n < _N; ++n) {
        _allocSlack.push_back(varCoeff[n]);
      }
      // Update the DTmin bounds 
      

      return 1;
    }
    else {
      cout << "lp solve returned infeasible" << endl;
      if (ret == INFEASIBLE)
        Tc = Tc*1.05;
      else {
        cout << "Check solver" << endl;
        return -1;
        //assert(0);
      }
      return 0;
    }
  } //rSA()
/*---------------------------------------------------------*/
} //namespace

//temp
    /*map<oaOccInstTerm*,double> riseSlackMap;
    map<oaOccInstTerm*,double> fallSlackMap;
    oaIter<oaOccInstTerm> itIter = cell->occInst->getInstTerms(); 
    while(oaOccInstTerm *iTerm = itIter.getNext()){
	TPoint *tp = TPoint::get(iTerm);
	if(tp->type == TIMING_POINT_SIGNAL_IN){
	    riseSlackMap[iTerm] = tp->getRiseSlack();
	    fallSlackMap[iTerm] = tp->getFallSlack();

	}
    }*/

	/*double dT = DBL_MAX;	
	oaIter<oaOccInstTerm> itIter2 = cell->occInst->getInstTerms(); 
	while(oaOccInstTerm *iTerm = itIter2.getNext()){
	    TPoint *tp = TPoint::get(iTerm);
	    if(tp->type == TIMING_POINT_SIGNAL_IN){
		double currRiseSlack = tp->getRiseSlack();
		double currFallSlack = tp->getFallSlack();

		if((riseSlackMap[iTerm]-currRiseSlack) < dT)
		    dT = riseSlackMap[iTerm] - currRiseSlack;
		else if((fallSlackMap[iTerm]-currFallSlack)<dT)
		    dT = fallSlackMap[iTerm] - currFallSlack;
	    }
	}
	cST.DT = dT;
	*/

	/*SubTimer subTP(d,t,cell->occInst,cST.name);
	double stdt = subTP.getWorstSlack();	
	std::cout << " LP) " << cell->instName << ":to" << newSize
	    << " dP:" << cST.DP << " dT:" 
	    << cST.DT 
	    << "/" << wOrigSlack-stdt << std::endl;
	    */
