/// \file 
///
/// Defines the associative container class \a Set as the most efficient
/// library class available.

#if !defined(oagSswSet_P)
#define oagSswSet_P

#ifdef __GNUC__
#include <ext/hash_set>

template<class Elem>
struct Set {
    typedef __gnu_cxx::hash_set<Elem>                           Type;
    typedef typename __gnu_cxx::hash_set<Elem>::iterator        iterator;
    typedef typename __gnu_cxx::hash_set<Elem>::const_iterator  const_iterator;
};

#else
#include <set>

template<class Elem>
struct Set {
    typedef std::set<Elem>                          Type;
    typedef typename std::set<Elem>::iterator       iterator;
    typedef typename std::set<Elem>::const_iterator const_iterator;
};

#endif

#endif
