#if !defined(oagSswObsAiGraph_P)
#define oagSswObsAiGraph_P

#include <set>
#include "oagSswSet.h"
#include "oagAiGraph.h"

namespace oagSsw {

/// \brief Observable and/inverter graph.
///
/// Nodes such as primary outputs can be marked as observable.  
class ObsAiGraph : public oagAi::Graph {
public:
                            ObsAiGraph() {}

  bool                      isObservable(oagAi::Ref x);
  void                      setObservable(oagAi::Ref    x,
                                          bool          observable);

  void                      getAllObservable(list<oagAi::Ref> &observable);

private:
  // Disallow copying.
                            ObsAiGraph(ObsAiGraph &other);
  ObsAiGraph                &operator=(ObsAiGraph &other);


  Set<oagAi::Ref>::Type     observables;


  friend class SatSweepingEngine;
  friend class OdcSatSweepingEngine;
};

inline bool
ObsAiGraph::isObservable(oagAi::Ref x)
{
    x = getNonInverted(x);
    return observables.find(x) != observables.end();
}

inline void
ObsAiGraph::setObservable(oagAi::Ref    x,
                          bool          observable)
{
    x = getNonInverted(x);
    if (observable) {
        observables.insert(x);
    } else {
        observables.erase(x);
    }
}

inline void
ObsAiGraph::getAllObservable(list<oagAi::Ref> & observable)
{
    observable.insert(observable.end(),
                      this->observables.begin(), this->observables.end());
}

}

#endif
