#include <cstdlib>
#include <ctime>
#include "oagSswLogger.h"

using namespace std;

namespace oagSsw
{
 
map<std::string, Logger *> *Logger::instances = NULL;

Logger *
Logger::getInstance(const std::string &name) {
    if (!instances) {
        instances = new map<string, Logger *>;
    }

    Logger * logger;
    map<string, Logger *>::iterator it = instances->find(name);
    if (it == instances->end()) {
        logger = new Logger(name);
        (*instances)[name] = logger;
    } else {
        logger = it->second;
    }
    return logger;
}

Logger &
Logger::logHeader() {
    time_t          t       = time(0);
    struct tm       locTm   = *localtime(&t);
    const size_t    N = 16;
    char            timeStr[N];
    const char      *FORMAT = "%H:%M:%S";

    strftime(timeStr, N - 1, FORMAT, &locTm);
    *stream << timeStr << " [" << name << "] ";
    return *this;
}

}
