#if !defined(oagSswAiSatSolver_P)
#define oagSswAiSatSolver_P

#include <map>
#include "oaBase.h"
#include "oagAiGraph.h"
#include "oagSswCircuitSatSolver.h"

namespace oagSsw
{

/// \brief Satisfiability solver for AI graphs.
class AiSatSolver : public CircuitSatSolver {
  public:
                            AiSatSolver(oagAi::Graph &graph);

    /// Returns true if a solver variable has been created for a node.
    bool                    hasVar(oagAi::Ref x);
    /// \brief Returns the solver variable that represents a node.
    ///
    /// If no such variable exists, a new one is created.
    Var                     varOf(oagAi::Ref x);
    /// \brief Returns the literal that represents a reference.
    ///
    /// If no solver variable for the reference does exists, a new one is
    /// created.
    Lit                     litOf(oagAi::Ref x);

    /// Searches for a satisfying assignment.
    lbool                   solve(oa::oaUInt4 maxConflicts = INT_MAX);

    /// \brief Returns the value assigned to a reference.
    ///
    /// The value is complemented for inverted references.
    /// Returns l_Undef if the solver has no variable for the node.
    lbool                   getValue(oagAi::Ref x);

    /// \brief Add unit clause
    void                    addUnit(Lit p) {
        if(ok) {
            ok = enqueue(p);
        }
    }

  private:
    oagAi::Graph                &graph;
    std::map<oagAi::Ref, Var>   aiVars;
};

}
#endif
