#include "oagSswAiSatSolver.h"

using namespace std;
using namespace oa;
using namespace oagAi;
using namespace oagMiniSat;

namespace oagSsw
{

AiSatSolver::AiSatSolver(oagAi::Graph &graph)
: CircuitSatSolver(),
  graph(graph)
{}

bool
AiSatSolver::hasVar(oagAi::Ref x)
{
    return aiVars.find(graph.getNonInverted(x)) != aiVars.end();
}

Var
AiSatSolver::varOf(oagAi::Ref x)
{
    x = graph.getNonInverted(x);
    map<Ref, Var>::iterator it = aiVars.find(x);
    if (it == aiVars.end()) {
        Var v = newVar();
        aiVars[x] = v;
        return v;
    } else {
        return it->second;
    }
}

Lit
AiSatSolver::litOf(oagAi::Ref x)
{
    return Lit(varOf(x), graph.isInverted(x));
}

lbool
AiSatSolver::solve(oa::oaUInt4 maxConflicts)
{
    addUnit(litOf(graph.constantOne()));
    return CircuitSatSolver::solve(maxConflicts);
}

lbool
AiSatSolver::getValue(oagAi::Ref x)
{
    if (hasVar(x)) {
        lbool v = model[varOf(x)];
        if (graph.isInverted(x)) {
            return v ^ true;
        } else {
            return v;
        }
    } else {
        return l_Undef;
    }
}

}
