#if !defined(oagSswAiLevelizer_P)
#define oagSswAiLevelizer_P

#include <map>
#include "oaBase.h"
#include "oagAiGraph.h"
#include "oagSswMap.h"

namespace oagSsw
{

/// \brief Computes levels of nodes in and/inverter graphs.
///
/// Constant nodes are at level 0.  Sequential nodes and null-driven terminals
/// are at level 1.  The level of any other node is one greater than the
/// maximum level of its inputs.
class AiLevelizer {
  public:
                            AiLevelizer(oagAi::Graph &graph);

    void                    initialLevels();
    void                    updateLevel(oagAi::Ref x);
    oa::oaUInt4             levelOf(oagAi::Ref x);
    void                    setLevelListLength(oa::oaUInt4 size);
    void                    setLevel(oagAi::Ref     x,
                                     oa::oaUInt4    level);
    void                    clear()     { levels.clear(); }

  private:
    oa::oaUInt4             initialLevelRec(oagAi::Ref x);

    // Disallow copying.
                            AiLevelizer(AiLevelizer & other);
    AiLevelizer &           operator=(AiLevelizer & other);
    oa::oaUInt4             getIndex(oagAi::Ref x);

    oagAi::Graph                        &graph;
    vector<oa::oaUInt4>                 levels;
};

}

#endif

// vim: ci et sw=4 sts=4 tw=80
