
/*
Author: Kai-hui Chang <changkh@eecs.umich.edu>
*/

///
/// \file oagResynSATCkt.h
/// SAT generator.

#if !defined(oagResynSATCkt_P)
#define oagResynSATCkt_P

#include "oaDesignDB.h"
#include "oagResynInternalCkt.h"
#include "oagResyn.h"

namespace oagResyn {

/// Each std::vector<int> is a clause, each int is a literal.
typedef std::vector< std::vector<int> > clauseType;

/// Generates some SAT CNF circuits.
class satCkt
{
public:
    void genComparator(int offsetBase, std::vector<int>& input1, std::vector<int>& input2,
                       clauseType& outputCNF, int& outputLitNO);
    void genOneCounter(int offsetBase, std::vector<int>& input, 
                       clauseType& outputCNF, std::vector<int>& output);
    void genAdder(int offsetBase, std::vector<int>& input1, std::vector<int>& input2,                       clauseType& outputCNF, std::vector<int>& output);
    void genMux(int input1, int input2, int sel, int output,
                clauseType& outputCNF);
    void printClause(clauseType& inputCNF);
    void printLitMap(std::map<oa::oaNet*, int>& litNOMap);
    void printIntVec(std::vector<int>& inputVec);
    void genInstMux(oa::oaDesign* design, int offsetBase, 
                    std::vector<oa::oaInst*>& insts, 
                    std::vector<oa::oaNet*>& allNets, 
                    std::vector<oa::oaNet*>& muxedNets, 
                    std::vector<int>& selLits, std::vector<int>& muxOutLits,
                    clauseType& outputCNF, std::map<oa::oaNet*, int>& litNOMap, 
                    int& largestLitNO);
    void genInsts(oa::oaDesign* design, int offsetBase, std::vector<oa::oaInst*>& insts, 
                     clauseType& outputCNF, std::map<oa::oaNet*, int>& litNOMap, 
                     int& largestLitNO);
protected:
    int getNetLitNO(oa::oaNet* inWire, std::map<oa::oaNet*, int>& litNOMap, int& litNO);
    void genInstsExec(oa::oaDesign* design, int offsetBase, std::vector<oa::oaInst*>& insts, 
                     clauseType& outputCNF, std::map<oa::oaNet*, int>& litNOMap, 
                     int& largestLitNO, int isw);
    
};


} // end of namespace
#endif
// vim: ci et sw=4 sts=4
