
/* 
Author: Kai-hui Chang <changkh@eecs.umich.edu>
*/

///
/// \file oagResynEquiCheck.h
/// Equivalence checker.

#if !defined(oagResynEquiCheck_P)
#define oagResynEquiCheck_P

#include <map>
#include "oagResyn.h"
#include "oagResynSATCkt.h"
#include "oagResynUserIntf.h" 

namespace oagResyn {

class simFactorSort{
public:
    SimulationVector vec;
    oa::oaNet* net;
    bool operator<(const simFactorSort& x) const {return vec < x.vec;};
};

/// \brief For equivalence checking.
class equiCheck :public equiCheckOutputInterface  {
public:
    const std::vector<SimulationVector>& getCounterExample();
    bool isTwoNet();
    bool isTwoDesign();
    const vector<SimulationVector>& getCounterExampleOutput1();
    const vector<SimulationVector>& getCounterExampleOutput2();
    const vector<oa::oaNet*>& getPrimaryInputs1();
    const vector<oa::oaNet*>& getPrimaryInputs2();
    const vector<oa::oaNet*>& getPrimaryOutputs1();
    const vector<oa::oaNet*>& getPrimaryOutputs2();
    int getNumCounterExamples();
    bool isEquivalent();
    double getSimilarityFactor();
    std::string getLib1();
    std::string getLib2();
    std::string getCell1();
    std::string getCell2();
    std::string getNet1();
    std::string getNet2();
    const std::vector<oa::oaNet*>& getDiffNets1();
    const std::vector<oa::oaNet*>& getDiffNets2();
    const std::map<oa::oaInst*, int>& getInstLevel1();
    const std::map<oa::oaInst*, int>& getInstLevel2();

    equiCheck();
    void getNetSignature(oa::oaDesign* design, oa::oaNet* net, std::vector<SimulationVector>& signature);
    bool checkEquiTwoNets(oa::oaDesign* design, oa::oaNet* net1, oa::oaNet* net2,
                      int& vecNumber, std::vector<oa::oaNet*>& inputs,  
                      std::vector<SimulationVector>& inputVecs, 
                      SimulationVector& outVec1, SimulationVector& outVec2);
    void printEquiCheckCNF(clauseType& inputCNF, 
                           std::map<oa::oaNet*, int>& litNOMap, 
                           int outputLitNO);
    double getSimilarityFactor(oa::oaDesign* design1, oa::oaDesign* design2, 
                               std::vector<oa::oaNet*>& netInput1, 
                               std::vector<oa::oaNet*>& netInput2);
    bool checkTwoDesignsAutoMap(oa::oaDesign* design1, oa::oaDesign* design2,
                        std::vector<oa::oaNet*>& netInput1, 
                        std::vector<oa::oaNet*>& netOutput1,
                        std::vector<oa::oaNet*>& netInput2, 
                        std::vector<oa::oaNet*>& netOutput2,
                        int& vecNumber, 
                        std::vector<SimulationVector>& inputVecs,
                        std::vector<SimulationVector>& outputVec1, 
                        std::vector<SimulationVector>& outputVec2);
    bool checkTwoDesigns(oa::oaDesign* design1,
                        std::vector<oa::oaNet*>& inputs1, 
                        std::vector<oa::oaNet*>& outputs1, 
                        oa::oaDesign* design2,
                        std::vector<oa::oaNet*>& inputs2, 
                        std::vector<oa::oaNet*>& outputs2, 
                        int& vecNumber, 
                        std::vector<SimulationVector>& inputVecs,
                        std::vector<SimulationVector>& outputVec1, 
                        std::vector<SimulationVector>& outputVec2);
    bool checkTwoCkts(oa::oaDesign* design1, std::vector<oa::oaInst*>& insts1, 
                     std::vector<oa::oaNet*>& inputs1, 
                     std::vector<oa::oaNet*>& outputs1, 
                     oa::oaDesign* design2,
                     std::vector<oa::oaInst*>& insts2, 
                     std::vector<oa::oaNet*>& inputs2,
                     std::vector<oa::oaNet*>& outputs2, 
                     int& vecNumber, 
                     std::vector<SimulationVector>& inputVecs, 
                     std::vector<SimulationVector>& outputVec1, 
                     std::vector<SimulationVector>& outputVec2);
    /// Number of patterns for random simulation
    unsigned int randomPatternNumber; 
    /// Current number of patterns simulated
    unsigned int currVectorNumber; 
protected:
    bool checkEquiSat(oa::oaDesign* design, oa::oaNet* net1, oa::oaNet* net2, 
                      int& vecNumber, std::vector<oa::oaNet*>& inputs,  
                      std::vector<SimulationVector>& inputVecs, 
                      SimulationVector& outVec1, 
                      SimulationVector& outVec2);
    bool checkEquiSimSat(oa::oaDesign* design, 
                         oa::oaNet* net1, oa::oaNet* net2,
                         int& vecNumber, std::vector<oa::oaNet*>& inputs,
                         std::vector<SimulationVector>& inputVecs,
                         SimulationVector& outVec1, SimulationVector& outVec2);
    void addPattern(oa::oaDesign* design, std::vector<oa::oaNet*>& inputs, 
                    std::vector<SimulationVector>& patterns, int vecNumber);
    void preSimulation(oa::oaDesign* design);
    void preSimulateTwoDesigns(oa::oaDesign* design1, 
                              std::vector<oa::oaNet*>& inputs1, 
                              oa::oaDesign* design2, 
                              std::vector<oa::oaNet*>& inputs2);
    int portGetLitNO(oa::oaNet* inNet, std::map<oa::oaNet*, int>& litNOMap, 
                     int& litNO);
    void clearSignature(oa::oaDesign *design);
    /// Internal SAT CNF generator
    satCkt mySatCkt;
    oa::oaDesign* designs[2];
    oa::oaNet* nets[2];
    bool twoNet;
    bool twoDesign;
    bool equi;
    std::vector<SimulationVector> counterExamples;
    std::vector<SimulationVector> counterExampleOutput1, counterExampleOutput2;
    std::vector<oa::oaNet*> PI1, PI2;
    std::vector<oa::oaNet*> PO1, PO2;
    std::vector<oa::oaNet*> diffNets1, diffNets2;
    std::map<oa::oaInst*, int> instLevelMap1, instLevelMap2;
    double similarityFactor;
    int counterExampleNO;
    bool showRuntime;
}; // of class equiCheck

}

#endif

// vim: ci et sw=4 sts=4
