#include "oagResyn.h"
#include <iostream>

using namespace oagResyn;
using namespace std;
using namespace oa;

// *****************************************************************************
// main() 
// *****************************************************************************
int main(int argc, const char **argv) {     
    std::auto_ptr<equiCheckOutputInterface> equiOut;
    string tmpstr;

    try
    {
	// Insert cells in libraries
	tmpstr= "INVX1";
	libManager.addCell(tmpstr);
	tmpstr= "BUFX1";
	libManager.addCell(tmpstr);
	tmpstr= "NAND2X1";
	libManager.addCell(tmpstr);
	tmpstr= "NAND3X1";
	libManager.addCell(tmpstr);
	tmpstr= "NAND4X1";
	libManager.addCell(tmpstr);
	tmpstr= "NOR2X1";
	libManager.addCell(tmpstr);
	tmpstr= "NOR3X1";
	libManager.addCell(tmpstr);
	tmpstr= "NOR4X1";
	libManager.addCell(tmpstr);
	tmpstr= "AOI21X1";
	libManager.addCell(tmpstr);
	tmpstr= "AOI22X1";
	libManager.addCell(tmpstr);
	tmpstr= "OAI21X1";
	libManager.addCell(tmpstr);
	tmpstr= "OAI22X1";
	libManager.addCell(tmpstr);
	equiOut= increVeriMain(argc, argv);
//	libManager.printLib();
	cout<<"Equivalence checking result: ";
        if (equiOut->isEquivalent() == true)
            cout<<"equivalent"<<endl;
	else
	    cout<<"not equivalent"<<endl;
	cout<<"Similarity factor: "<<equiOut->getSimilarityFactor()<<endl;
	cout<<"Different wires:";
	for (vector<oaNet*>::const_iterator netIter= equiOut->getDiffNets2().begin();
	     netIter != equiOut->getDiffNets2().end(); netIter++)
	{
	    cout<<" "<<getNameFromOA(*netIter);
	}
	cout<<endl;
    } catch(oa::oaException &e) {
        std::cerr << "ERROR: " << e.getMsg() << std::endl;
        assert(false);
        return 1;
    } catch(oagResynErr& e)
    {
        std::cerr<<e.what()<<endl;
        return 1;
    }
    return 0;
}

