#ifndef oagRedunStuckAtRedunCB_P
#define oagRedunStuckAtRedunCB_P

#include "oaDesignDB.h"

namespace oagRedun {

class StuckAtRedunCB {
protected:
    oa::oaNet * const tie0;
    oa::oaNet * const tie1;
public:
    StuckAtRedunCB(oa::oaNet *t0, oa::oaNet *t1) : tie0(t0), tie1(t1) { }
    virtual ~StuckAtRedunCB() { }

    /// Returns TRUE if removing 'a' is preferable to removing 'b'
    virtual bool pinSort(oa::oaInstTerm *a, oa::oaInstTerm *b) { 
        return false;
    }
    /// This function gets called to remove redundancies
    virtual void removeRedundancy(oa::oaInstTerm *t, unsigned stuckAtVal) {
	if (stuckAtVal == 0) t->addToNet(tie0);
	if (stuckAtVal == 1) t->addToNet(tie1);
    }
};

}
#endif
