#ifndef oagRedunFlattener_P
#define oagRedunFlattener_P
#include "oagAiGraph.h"
#include "oagFuncReasoningEngine.h"
#include "oaDesignDB.h"
#include <map>
#include <vector>
#include <exception>

namespace oagRedun {

class Flattener {
    class AiReasoningEngine : public oagFunc::ReasoningEngine<oagAi::Ref> {
    public:
        AiReasoningEngine(oagAi::Graph & graph) : graph(graph) { }
        virtual oagAi::Ref getZero() { 
            return graph.constantZero(); 
        }
        virtual oagAi::Ref andOf(oagAi::Ref a, oagAi::Ref b) {
            return graph.andOf(a, b);
        }
        virtual oagAi::Ref notOf(oagAi::Ref a) {
            return graph.notOf(a);
        }
        oagFunc::GenericFunction genericNewTerminal() {
            return getFunc(graph.newTerminal(graph.getNull()));
        }
        oagAi::Ref getRef(oagFunc::GenericFunction f) {
            // FIXME avoid cast error on 64-bit
            return (oagAi::Ref)(f);
        }
        oagFunc::GenericFunction getFunc(oagAi::Ref x) {
            // FIXME avoid cast error on 64-bit
            return (oagFunc::GenericFunction)(x);
        }

        oagAi::Graph & getGraph() {
            return graph;
        }

    private:
        oagAi::Graph & graph;
    };
    oa::oaBlock                              *_block;
    oagAi::Graph                             &_graph;
    std::vector<oagAi::Ref>                  &_inputs;
    std::vector<oagAi::Ref>                  &_outputs;

    AiReasoningEngine                         _are;

    std::map<oa::oaBitNet*,   oagAi::Ref>     _drivers;
    std::map<oa::oaInstTerm*, oagAi::Ref>     _iInstTerms;

    void setupInputs();
    void setupInsts();
    void setupOutputs();

    void setDriver(oa::oaBitNet *, oagAi::Ref);
public:
    Flattener(oa::oaDesign *, oagAi::Graph &, std::vector<oagAi::Ref> &i, std::vector<oagAi::Ref> &o);
    ~Flattener();

    oagAi::Ref getDriver(oa::oaBitNet *) const;
    oagAi::Ref getTerm(oa::oaInstTerm *) const;

    struct FloatingNetException : public std::exception {
        virtual const char* what() const throw() {
            return "Flattener encountered a floating net";
        }
    };
    struct CycleException : public std::exception {
        virtual const char* what() const throw() {
            return "Flattener encountered a cycle";
        }
    };
};

}
#endif
// vim:et:
