/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: Aaron P. Hurst <ahurst@eecs.berkeley.edu>
 
ChangeLog:
2005-08-18: ChangeLog started
*/

#if !defined(oagMapperSimple_P)
#define oagMapperSimple_P

#include "oaDesignDB.h"
#include "oagFunc.h"
#include "oagFuncModGraph.h"
#include <map>

using namespace std;

namespace oagMapper {

// *****************************************************************************
// Simple
//
/// \brief A trivial mapper that uses a cell library consisting of and and not combinational gates.
//
// *****************************************************************************

class Simple {

  public:
  
    typedef enum{POSEDGE, NEGEDGE} TriggerType;
  
                        Simple(oa::oaDesign *andGate, oa::oaDesign *notGate,
                               oa::oaDesign *sequentialGate);
    
    void                techmap(oa::oaModule *target);
    oa::oaModBitNet*    techmap(oagFunc::ModRef ref);
    
    /// \name Identification of Sequential Control Signals
    /// @{
    
    void                useFirstTriggersAsClocks() {
        clockNet = NULL;
    }
    void                useSingleGlobalClock(oa::oaModBitNet *clock, TriggerType trig = POSEDGE) {
        clockNet = clock;
        clockNetTrigger = trig;
    }
    void                useSecondTriggersAsResets() {
        resetNet = NULL;
    }
    void                useSingleGlobalReset(oa::oaModBitNet *reset, TriggerType trig = POSEDGE) {
        resetNet = reset;
        resetNetTrigger = trig;
    }
    
    void                mergeEquivalentNets(oa::oaModule *module);
    
    /// @}
    
  protected:
    
    map<oagFunc::ModRef, oa::oaModBitNet*>   mappedRefs;
    
    /// \name Sequential control signals
    /// @{
    
    oa::oaModBitNet    *resetNet, *clockNet;
    TriggerType         resetNetTrigger, clockNetTrigger;
    
    /// @}
    /// \name Library cell terminals by function
    /// @{
    
    oa::oaDesign       *andGate;
    oa::oaModTerm      *andInput0, *andInput1, *andOutput;
    int                 andCount;
    
    oa::oaDesign       *notGate;
    oa::oaModTerm      *notInput, *notOutput;
    int                 notCount;
    
    oa::oaDesign       *sequentialGate;
    oa::oaModTerm      *seqInput, *seqOutput;
    oa::oaModTerm      *seqReset, *seqPreset, *seqClock;
    TriggerType         seqClockTrigger, seqResetTrigger, seqPresetTrigger;
    int                 seqCount;
    
    /// @}
    /// \name Identification of library cell terminals by function
    /// @{
    
    void                identifyAndTerminals();
    void                identifyNotTerminals();
    void                identifySeqTerminals();

    /// @}
    /// \name Mapping sequential signals
    /// @{
    
    void                removeSeqControlsFromLogic();
    void                connectSeqControls(oagFunc::ModRef ref, oa::oaModInst *inst);
    
    /// @}

};

}
#endif
