/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: Aaron P. Hurst <ahurst@eecs.berkeley.edu>
 
ChangeLog:
2006-12-25: ChangeLog started
*/

#include "oagFuncVerilogDesign.h"

namespace oagFunc {


// *****************************************************************************
// ~VerilogDesign()
//
/// \brief Destructor.
//
// *****************************************************************************
VerilogDesign::~VerilogDesign() {
  if (!DELETE_UPON_DESTRUCTION) return;
  // delete modules
  for(std::list<Module *>::iterator it=modules.begin(); it != modules.end(); it++) 
    delete (*it);
}


// *****************************************************************************
// VerilogDesign::~Module()
//
/// \brief Destructor.
//
// *****************************************************************************
VerilogDesign::Module::~Module() {
  if (!DELETE_UPON_DESTRUCTION) return;
  // delete ports
  if (ports) {
    for(std::list<Port *>::iterator it=ports->begin(); it!=ports->end(); it++) 
      delete (*it);
    delete ports;
  }
  // delete assignments
  if (assignments) {
    for(std::list<Assignment *>::iterator it=assignments->begin(); it!=assignments->end(); it++) 
      delete (*it);
    delete assignments;
  }
  // delete always blocks
  if (alwaysBlocks) {
    for(std::list<AlwaysBlock *>::iterator it=alwaysBlocks->begin(); it!=alwaysBlocks->end(); it++) 
      delete (*it);
    delete alwaysBlocks;
  }
  // delete initial blocks
  if (initialBlocks) {
    for(std::list<Statement *>::iterator it=initialBlocks->begin(); it!=initialBlocks->end(); it++) 
      delete (*it);
    delete initialBlocks;
  }
  // delete functions
  if (functions) {
    for(std::list<Function *>::iterator it=functions->begin(); it!=functions->end(); it++) 
      delete (*it);
    delete functions;
  }
  // delete instantiations
  if (functions) {
    for(std::list<Function *>::iterator it=functions->begin(); it!=functions->end(); it++) 
      delete (*it);
    delete functions;
  }
  // delete declarations
  for(std::list<Declaration *>::iterator it=declarations.begin(); it!=declarations.end(); it++) 
    delete (*it);
  // delete parameters
  for(std::list<Declaration *>::iterator it=parameters.begin(); it!=parameters.end(); it++) 
    delete (*it);
  // delete parameter overrides
  if (parameterOverrides) {
    for(std::list<Declaration *>::iterator it=parameterOverrides->begin(); it!=parameterOverrides->end(); it++) 
      delete (*it);
    delete parameterOverrides;
  }
}


// *****************************************************************************
// VerilogDesign::~Declaration()
//
/// \brief Destructor.
//
// *****************************************************************************
VerilogDesign::Declaration::~Declaration() {
  if (!DELETE_UPON_DESTRUCTION) return;
  if (start)
    delete start;
  if (stop && start != stop)
    delete stop;
  if (start2D)
    delete start2D;
  if (stop && start2D != stop2D)
    delete stop2D;
  if (value)
    delete value;
}


// *****************************************************************************
// VerilogDesign::~Function()
//
/// \brief Destructor.
//
// *****************************************************************************
VerilogDesign::Function::~Function() {
  if (!DELETE_UPON_DESTRUCTION) return;  
  if (declarations) {
    for(std::list<Declaration*>::iterator it=declarations->begin(); it!=declarations->end(); it++) 
      delete (*it);
    delete declarations;
  }
  if (start)
    delete start;
  if (stop && start != stop)
    delete stop;
  if (action)
    delete action;
}


// *****************************************************************************
// VerilogDesign::~Trigger()
//
/// \brief Destructor.
//
// *****************************************************************************
VerilogDesign::Trigger::~Trigger() {
  if (!DELETE_UPON_DESTRUCTION) return;  
  if (net)
    delete net;
}


// *****************************************************************************
// VerilogDesign::~Assignment()
//
/// \brief Destructor.
//
// *****************************************************************************
VerilogDesign::Assignment::~Assignment() {
  if (!DELETE_UPON_DESTRUCTION) return;  
  if (lval)
    delete lval;
  if (value)
    delete value;
}


// *****************************************************************************
// VerilogDesign::~AlwaysBlock()
//
/// \brief Destructor.
//
// *****************************************************************************
VerilogDesign::AlwaysBlock::~AlwaysBlock() {
  if (!DELETE_UPON_DESTRUCTION) return;  
  if (action)
    delete action;
  if (triggers) {
    for(std::list<Trigger*>::iterator it=triggers->begin(); it!=triggers->end(); it++) 
      delete (*it);
    delete triggers;
  }
}


// *****************************************************************************
// VerilogDesign::~Case()
//
/// \brief Destructor.
//
// *****************************************************************************
VerilogDesign::Case::~Case() {
  if (!DELETE_UPON_DESTRUCTION) return;  
  if (action)
    delete action;
  if (conditions) {
    for(std::list<Expression*>::iterator it=conditions->begin(); it!=conditions->end(); it++) 
      delete (*it);
    delete conditions;
  }
}


// *****************************************************************************
// VerilogDesign::~Statement()
//
/// \brief Destructor.
//
// *****************************************************************************
VerilogDesign::Statement::~Statement() {
  if (!DELETE_UPON_DESTRUCTION) return;  
  if (ifc.condition)
    delete ifc.condition;
  if (ifc.ifTrue)
    delete ifc.ifTrue;
  if (ifc.ifFalse)
    delete ifc.ifFalse;
  if (ifc.cases) {
    for(std::list<Case*>::iterator it=ifc.cases->begin(); it!=ifc.cases->end(); it++) 
      delete (*it);
    delete ifc.cases;
  }
  if (assign.lval)
    delete assign.lval;
  if (assign.rval)
    delete assign.rval;
  if (begin_end.block) {
    for(std::list<Statement*>::iterator it=begin_end.block->begin(); it!=begin_end.block->end(); it++) 
      delete (*it);
    delete begin_end.block;
  }
  if (begin_end.declarations) {
    for(std::list<Declaration*>::iterator it=begin_end.declarations->begin(); it!=begin_end.declarations->end(); it++) 
      delete (*it);
    delete begin_end.declarations;
  }
}


// *****************************************************************************
// VerilogDesign::~Instantiation()
//
/// \brief Destructor.
//
// *****************************************************************************
VerilogDesign::Instantiation::~Instantiation() {
  if (!DELETE_UPON_DESTRUCTION) return;  
  if (parameters) {
    for(std::list<Expression*>::iterator it=parameters->begin(); it!=parameters->end(); it++) 
      delete (*it);
    delete parameters;
  }
  if (connections) {
    for(std::list<PortConnection*>::iterator it=connections->begin(); it!=connections->end(); it++) 
      delete (*it);
    delete connections;
  }
}


// *****************************************************************************
// VerilogDesign::~PortConnection()
//
/// \brief Destructor.
//
// *****************************************************************************
VerilogDesign::PortConnection::~PortConnection() {
  if (!DELETE_UPON_DESTRUCTION) return;  
  if (value)
    delete value;
}


// *****************************************************************************
// VerilogDesign::~Expression()
//
/// \brief Destructor.
//
// *****************************************************************************
VerilogDesign::Expression::~Expression() {
  if (!DELETE_UPON_DESTRUCTION) return;  
  if (type == PRIMARY) {
    if (primary)
      delete primary;
    return;
  }
  if (type == BUNDLE) {
    if (primary)
      delete primary;
    return;
  }
  if (op1)
    delete op1;
  if (op2)
    delete op2;
  if (op3)
    delete op3;
}


// *****************************************************************************
// VerilogDesign::~Primary()
//
/// \brief Destructor.
//
// *****************************************************************************
VerilogDesign::Primary::~Primary() {
  if (!DELETE_UPON_DESTRUCTION) return;  
  if (range.start)
    delete range.start;
  if (range.stop && range.start != range.stop)
    delete range.stop;
  if (arguments) {
    for(std::list<Expression*>::iterator it=arguments->begin(); it!=arguments->end(); it++) 
      delete (*it);
    delete arguments;
  }
}


// *****************************************************************************
// VerilogDesign::~Bundle()
//
/// \brief Destructor.
//
// *****************************************************************************
VerilogDesign::Bundle::~Bundle() {
  if (!DELETE_UPON_DESTRUCTION) return;  
  if (replication)
    delete replication;
  if (members) {
    for(std::list<Expression*>::iterator it=members->begin(); it!=members->end(); it++) 
      delete (*it);
    delete members;
  }
}

}
