/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: Aaron P. Hurst <ahurst@eecs.berkeley.edu>
 
ChangeLog:
2005-05-31: ChangeLog started
*/

#if !defined(oagFuncSimOcc_P)
#define oagFuncSimOcc_P

#include "oaDesignDB.h"
#include "oagFunc.h"
#include "oagFuncOccGraph.h"
#include <list>
#include <map>
#include <set>

using namespace std;

namespace oagFunc {

typedef unsigned int SimulationVector;

// *****************************************************************************
// Simulator
//
/// \brief An object for simulating input vectors on hierarchical designs.
//
// *****************************************************************************

class SimOcc {

  public:
  
    typedef unsigned int SimVec;

                        SimOcc(oa::oaDesign *design);
    
    void                setVector(OccRef &ref, SimulationVector vec);
    void                generateRandomInputVectors();
    void                generateRandomStateVectors();
    void                clear();
    
    void                nextCycle();
    
    void                runFull();
    
    void                initializeIncremental();
    void                runIncremental();

    bool                getVector(const OccRef &ref, SimulationVector &vec);
    
  protected:
  
    SimulationVector    randomVector();
    int                 BITS_PER_RAND;

    oa::oaDesign                    *design;
    list<OccRef>                    toBeSimulated;
    map<OccRef, SimulationVector>   data;
};

}

#endif
