/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: Aaron P. Hurst <ahurst@eecs.berkeley.edu>
 
ChangeLog:
2005-05-31: ChangeLog started
*/

#if !defined(oagFuncQueryMod_P)
#define oagFuncQueryMod_P

#include "oaDesignDB.h"
#include "oagFunc.h"
#include "oagFuncReasoningEngine.h"
#include "oagFuncModGraph.h"
#include <list>
#include <map>
#include <set>

using namespace std;

namespace oagFunc {

// *****************************************************************************
// QueryMod
//
/// \brief An object for performing functional queries on OpenAccess designs.
//
// *****************************************************************************

class QueryMod {

  public:
  
                        QueryMod(oa::oaDesign *design, 
                                 GenericReasoningEngine *engine);

    GenericFunction     getNextState(oa::oaModBitNet *net);
    GenericFunction     getNextState(ModRef &ref);
    
    GenericFunction     get(oa::oaModBitNet *net);
    GenericFunction     get(ModRef &ref);

    void                set(oa::oaModBitNet *net, GenericFunction f);
    void                set(ModRef &ref, GenericFunction f);

    void                unset(oa::oaModBitNet *net);
    void                unset(ModRef &ref);    
    
  protected:
  
    oa::oaDesign           *design;
    GenericReasoningEngine *engine;

  private:
    
    GenericFunction                getRecursively(ModRef &g);
    
    map<ModRef,GenericFunction>    precomputedCache;
    map<ModRef,GenericFunction>    setFunctionsOnRefs;
 
    std::set<ModRef>               visitedSet;
    
};

}

#endif
