/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: Aaron P. Hurst <ahurst@eecs.berkeley.edu>
 
ChangeLog:
2005-06-21: ChangeLog started
*/

#if !defined(oagFuncOccRef_P)
#define oagFuncOccRef_P

#include <stdlib.h>

#include "oaDesignDB.h"
#include "oagFuncModRef.h"
#include "oagAiRef.h"

namespace oagFunc {

// *****************************************************************************
// OccRef
//
/// \brief A reference into an and/inverter graph in a particular Occurrence object.
///
/// The reference may refer to the function implemented by a node or its
/// inverse.
//
// *****************************************************************************

class OccRef {
  public:
                      OccRef() {
                          ref = 0; occurrence = NULL;
                      }
                      OccRef(const OccRef &copy) {
                          ref = copy.ref; occurrence = copy.occurrence;
                      }
                      OccRef(oagAi::Ref a, oa::oaOccurrence *o) {
                          ref = a; occurrence = o;
                      }
  
    oagAi::Ref        ref;
    oa::oaOccurrence *occurrence;

    bool              operator<(const OccRef &comp) const {
                          /// This operator involves a pointer comparison
                          /// and will not produce the same ordering
                          /// if the memory locations of occurrences
                          /// change.  This may be the case in two different
                          /// executions, or if portions of the
                          /// database are purged and reloaded.
    
                          if (occurrence != comp.occurrence) 
                              return occurrence<comp.occurrence; 
                          else 
                              return ref<comp.ref; 
                      }
    bool              operator==(const OccRef &comp) const {
                          return occurrence == comp.occurrence && ref == comp.ref;
                      }
    bool              operator!=(const OccRef &comp) const {
                          return occurrence != comp.occurrence || ref != comp.ref;
                      }
                      
    ModRef            getModRef() {
                          /// \brief Gets the ModRef of the corresponding module-domain node.
                          return ModRef(ref, occurrence->getModule());
                      }
                    
    void              printName(bool lineFeed = true); 
    void              print(bool lineFeed = true); 
};

}

#endif
