/* (c) Copyright 2004-2005, Cadence Design Systems, Inc.  All rights reserved. 

This file is part of the OA Gear distribution.  See the COPYING file in
the top level OA Gear directory for copyright and licensing information. */

/*
Author: Aaron P. Hurst <ahurst@eecs.berkeley.edu>
 
ChangeLog:
2005-05-31: ChangeLog started
*/

#if !defined(oagFuncMultiRef_P)
#define oagFuncMultiRef_P

#include "oaDesignDB.h"
#include "oagAiRef.h"
#include <list>
#include <map>

using namespace std;

namespace oagFunc {

// *****************************************************************************
// Type definitions for various Verilog objects.
// *****************************************************************************

typedef enum {AIREF, NET, NEITHER}  MultiRefType;
typedef list<class MultiRef>        MultiRefBus;

// *****************************************************************************
// MultiRef
///
/// \brief A reference to a single-bit function, either an oaModBitNet* or an oagAi::Ref
//
/// The MultiRef is used in synthesis because it is often advantageous to delay
/// converting the named design objects into AI nodes.  It allows some actions
/// to be identified as purely structural and handled differently (such as
/// continuous assigns that involve only wires).
///
// *****************************************************************************

class MultiRef {

  public:
  
    MultiRefType            type;

    union {
      oa::oaModBitNet        *net;
      oagAi::Ref              ai;
    };    

    /// Constructs a null reference
    MultiRef()                    { type = NEITHER; }
    /// Constructs a reference to an oaModBitNet
    MultiRef(oa::oaModBitNet *n)  { net = n; type = NET; }
    /// Constructs a reference to an oagAi::Ref
    MultiRef(oagAi::Ref a)        { ai = a; type = AIREF; }
    /// Copy constructor
    MultiRef(const MultiRef &e)   { memcpy(this, &e, sizeof(MultiRef)); }
  
    MultiRef &              operator=(const MultiRef &e)  { memcpy(this, &e, sizeof(MultiRef)); return *this; }
    bool                    operator==(const MultiRef &e) { if (type != e.type) return false; else if (type == NEITHER) return true; else if (type == NET) return net == e.net; else return ai == e.ai; }
    
};

}

#endif
